/**
 * \file
 *
 * \brief Timer counter register interface
 *
 * - Compiler:           IAR EWAVR32 and GNU GCC for AVR32
 * - Supported devices:  All devices
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 * Atmel AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

#ifndef TIMER_TC_REGS_H_INCLUDED
#define TIMER_TC_REGS_H_INCLUDED

#include <chip/memory-map.h>
#include <io.h>

/* Register offsets */
#define TC_BCR				0x00c0
#define TC_BMR				0x00c4

#define TC_CCR				0x0000
#define TC_CMR				0x0004
#define TC_CV				0x0010
#define TC_RA				0x0014
#define TC_RB				0x0018
#define TC_RC				0x001c
#define TC_SR				0x0020
#define TC_IER				0x0024
#define TC_IDR				0x0028
#define TC_IMR				0x002c


#define TC_CCR_CLKEN_MASK		(1 << 0)
#define TC_CCR_SWTRG_MASK		(1 << 2)
#define TC_CCR_CLKDIS_MASK		(1 << 1)

#define TC_CMR_WAVE_MASK		(1 << 15)

#define TC_SR_COVFS_MASK		(1 << 0)
#define TC_SR_CPAS_MASK			(1 << 2)


/** \brief Read GPIO register \a reg on \a port */
#define tc_read_reg(port, reg)				\
	mmio_read32((port) + TC_##reg)
/** \brief Write \a value to GPIO register \a reg on \a port */
#define tc_write_reg(port, reg, value)			\
	mmio_write32((port) + TC_##reg, value)

#endif /* TIMER_TC_REGS_H_INCLUDED */

