/**
 * \file
 *
 * \brief SD/MMC card protocol definitions
 *
 * - Compiler:           IAR EWAVR32 and GNU GCC for AVR32
 * - Supported devices:  All devices
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 * Atmel AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
#ifndef MMC_PROTOCOL_H_INCLUDED
#define MMC_PROTOCOL_H_INCLUDED

/* Max clock rate during identification */
#define SDMMC_F_OD	200000

/*      Name                         CMDx */
/* Class 0 - Basic */
#define SDMMC_GO_IDLE_STATE		0
#define MMC_SEND_OP_COND		1
#define SDMMC_ALL_SEND_CID		2
#define SDMMC_SET_RELATIVE_ADDR		3
#define SDMMC_SET_DSR			4
/* CMD5 is reserved for SDIO */
#define SDMMC_SWITCH_FUNC		6
#define SDMMC_SELECT_DESELECT_CARD	7
#define SD_SEND_IF_COND			8
#define MMC_SEND_EXT_CSD		8
#define SDMMC_SEND_CSD			9
#define SDMMC_SEND_CID			10
#define SDMMC_STOP_TRANSMISSION		12
#define SDMMC_SEND_STATUS		13
#define MMC_BUSTEST_R			14
#define SDMMC_GO_INACTIVE_STATE		15

/* Class 1 - Stream read */
#define MMC_READ_DAT_UNTIL_STOP		11

/* Class 2 - Block read */
#define SDMMC_SET_BLOCKLEN		16
#define SDMMC_READ_SINGLE_BLOCK		17
#define SDMMC_READ_MULTIPLE_BLOCK	18

/* Class 3 - Stream write */
#define MMC_WRITE_DATA_UNTIL_STOP	20

/* Class 4 - Block write */
/* CMD16 SDMMC_SET_BLOCKLEN is also a part of this class */
#define MMC_SET_BLOCK_COUNT		23
#define SDMMC_WRITE_BLOCK		24
#define SDMMC_WRITE_MULTIPLE_BLOCK	25
#define MMC_PROGRAM_CID			26
#define SDMMC_PROGRAM_CSD		27

/* Class 5 - Erase */

/* Class 6 - Write protection */
#define SDMMC_SET_WRITE_PROT		28
#define SDMMC_CLR_WRITE_PROT		29
#define SDMMC_SEND_WRITE_PROT		30

/* Class 7 - Lock Card */

/* Class 8 - Application specific */
#define SDMMC_APP_CMD			55
#define SDMMC_GEN_CMD			56

/* Class 9 - I/O mode */

/* Class 10 - Switch */

/* Application specific commands */
/*      Name                        ACMDx */
#define SD_SET_BUS_WIDTH		6
#define SD_SEND_OP_COND			41
#define SD_SEND_SCR			51

/* argument definitions */
#define SD_ARG_SET_BUS_WIDTH_4BIT	2


/**
 * \brief Card status (response R1)
 */
#define SDMMC_OUT_OF_RANGE		(1 << 31)
#define SDMMC_ADDRESS_ERROR		(1 << 30)
#define SDMMC_BLOCK_LEN_ERROR		(1 << 29)
#define SDMMC_ERASE_SEQ_ERROR		(1 << 28)
#define SDMMC_ERASE_PARAM		(1 << 27)
#define SDMMC_WP_VIOLATION		(1 << 26)
#define SDMMC_CARD_IS_LOCKED		(1 << 25)
#define SDMMC_LOCK_UNLOCK_FAILED	(1 << 24)
#define SDMMC_COM_CRC_ERROR		(1 << 23)
#define SDMMC_ILLEGAL_COMMAND		(1 << 22)
#define SDMMC_CARD_ECC_FAILED		(1 << 21)
#define SDMMC_CC_ERROR			(1 << 20)
#define SDMMC_ERROR			(1 << 19)
#define MMC_UNDERRUN			(1 << 18)
#define MMC_OVERRUN			(1 << 17)
#define SDMMC_CSD_OVERWRITE		(1 << 16)
#define SDMMC_WP_ERASE_SKIP		(1 << 15)
#define SD_CARD_ECC_DISABLED		(1 << 14)
#define SDMMC_ERASE_RESET		(1 << 13)
#define SDMMC_CURRENT_STATE_MASK	(15 << 9)
#define SDMMC_CURRENT_STATE_IDLE	(0 << 9)
#define SDMMC_CURRENT_STATE_READY	(1 << 9)
#define SDMMC_CURRENT_STATE_IDENT	(2 << 9)
#define SDMMC_CURRENT_STATE_STBY	(3 << 9)
#define SDMMC_CURRENT_STATE_TRAN	(4 << 9)
#define SDMMC_CURRENT_STATE_DATA	(5 << 9)
#define SDMMC_CURRENT_STATE_RCV		(6 << 9)
#define SDMMC_CURRENT_STATE_PRG		(7 << 9)
#define SDMMC_CURRENT_STATE_DIS		(8 << 9)
#define MMC_CURRENT_STATE_BTST		(9 << 9)
#define SDMMC_READY_FOR_DATA		(1 << 8)
#define MMC_SWITCH_ERROR		(1 << 7)
#define SDMMC_CARD_STATUS_APP_CMD	(1 << 5)
#define SD_AKA_SEQ_ERROR		(1 << 3)

/**
 * \brief RCA (response R6)
 */
#define SDMMC_RCA_MASK			(0xffff << 16)

/** \brief Switch func argument definitions */
#define SDMMC_SWITCH_FUNC_MODE_CHECK	(0 << 31)	/**< Check function */
#define SDMMC_SWITCH_FUNC_MODE_SWITCH	(1 << 31)	/**< Switch function */
#define SDMMC_SWITCH_FUNC_HIGH_SPEED	(1 << 0)	/**< High Speed */
#define SDMMC_SWITCH_FUNC_G1_KEEP	(0xf << 0)	/**< Group 1 No influence */
#define SDMMC_SWITCH_FUNC_G2_KEEP	(0xf << 4)	/**< Group 2 No influence */
#define SDMMC_SWITCH_FUNC_G3_KEEP	(0xf << 8)	/**< Group 3 No influence */
#define SDMMC_SWITCH_FUNC_G4_KEEP	(0xf << 12)	/**< Group 4 No influence */
#define SDMMC_SWITCH_FUNC_G5_KEEP	(0xf << 16)	/**< Group 5 No influence */
#define SDMMC_SWITCH_FUNC_G6_KEEP	(0xf << 20)	/**< Group 6 No influence */

/**
 * \brief Interface condition (Command CMD8 and response R7)
 */
#define SD_IF_COND_V_27_33		(1 << 8)	/**< Voltage 2.7V - 3.3V */
#define SD_IF_COND_CHECK_PATTERN	0xaa		/**< Check pattern that should be echoed back on R7 */

/**
 * \brief OCR register definitions
 */
#define SDMMC_OCR_POWER_UP_DONE		(1 << 31)	/**< Card power up status bit */
#define SDMMC_OCR_CCS			(1 << 30)	/**< Card Capacity Status. High for HC cards. */
#define SDMMC_OCR_V_32_33		(1 << 20)	/**< 3.2 - 3.3 V */
#define SDMMC_OCR_V_33_34		(1 << 21)	/**< 3.3 - 3.4 V */
#define SDMMC_OCR_LOW_VOLTAGE		(1 << 7)	/**< Low voltage flag (Reserved in SD 2.0 and 1.7-1.95 in MMC 4.2) */

/**
 * \brief SCR register definitions
 */
#define SD_SCR0_VERSION_MASK		(0xf << (60 - 32))	/**< SCR Version */
#define SD_SCR0_VERSION_101_200		(0 << (60 - 32))	/**< SD version 1.01 to 2.00 */
#define SD_SCR0_SPEC_VERSION_MASK	(0xf << (56 - 32))	/**< Specification version */
#define SD_SCR0_SPEC_VERSION_10_101	(0 << (56 - 32))	/**< SD version 1.0 to 1.01 */
#define SD_SCR0_SPEC_VERSION_110	(1 << (56 - 32))	/**< SD version 1.10 */
#define SD_SCR0_SPEC_VERSION_200	(2 << (56 - 32))	/**< SD version 2.00 */
#define SD_SCR0_BUS_WIDTH_1BIT_MASK	(1 << (48 - 32))	/**< 1 bit bus support */
#define SD_SCR0_BUS_WIDTH_4BIT_MASK	(1 << (48 - 32))	/**< 4 bit bus support */

#endif /* MMC_PROTOCOL_H_INCLUDED */

