/**
 * \file
 *
 * \brief AES module register interface
 *
 * - Compiler:           IAR EWAVR32 and GNU GCC for AVR32
 * - Supported devices:  All devices
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 * Atmel AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

#ifndef AES_REGS_H_INCLUDED
#define AES_REGS_H_INCLUDED

#include <io.h>

#define AES_CR				0x0000
#define AES_CR_SWRST			0x0010
#define AES_MR				0x0004
#define AES_MR_CIPHER_MASK			(1 << 0)
#define AES_MR_CIPHER_OFFSET	0
#define AES_MR_START_MODE_MANUAL	(0)
#define AES_MR_START_MODE_AUTO		(1 << 8)
#define AES_MR_START_MODE_DMA		(1 << 9)
#define AES_MR_LOD			0x0080
#define AES_IER				0x0010
#define AES_IDR				0x0014
#define AES_IMR				0x0018
#define AES_ISR			0x001c
#define AES_KEY1		0x0020
#define AES_KEY2		0x0024
#define AES_KEY3		0x0028
#define AES_KEY4		0x002c
#define AES_KEY5		0x0030
#define AES_KEY6		0x0034
#define AES_KEY7		0x0038
#define AES_KEY8		0x003c
#define AES_INPUT1		0x0040
#define AES_INPUT2		0x0044
#define AES_INPUT3		0x0048
#define AES_INPUT4		0x004c
#define AES_OUTPUT1		0x0050
#define AES_OUTPUT2		0x0054
#define AES_OUTPUT3		0x0058
#define AES_OUTPUT4		0x005c
#define AES_INIT1		0x0060
#define AES_INIT2		0x0064
#define AES_INIT3		0x0068
#define AES_INIT4		0x006c

//#define SPI_MR_PCS(x)		(x << 16)
//#define SPI_MR_PCS_MASK		((0xf) << 16)

/* Register access macros */
#define aes_read_reg(port, reg)					\
	mmio_read32((port) + AES_##reg)
#define aes_write_reg(port, reg, value)				\
	mmio_write32((port) + AES_##reg, value)

#define aes_write_key_reg(port, index, value)			\
	mmio_write32((port) + AES_KEY1 + (4 * index), value)
#define aes_write_init_reg(port, index, value)			\
	mmio_write32((port) + AES_INIT1 + (4 * index), value)
#define aes_write_input_reg(port, index, value)			\
	mmio_write32((port) + AES_INPUT1 + (4 * index), value)
#define aes_read_output_reg(port, index)			\
	mmio_read32((port) + AES_OUTPUT1 + (4 * index))

#endif /* AES_REGS_H_INCLUDED */

