/**
 * \file
 *
 * \brief SD/MMC Driver Documentation Overview
 *
 * This file provides an overview of the SD/MMC driver. It does not
 * contain any code by itself.
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 * Atmel AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * \page sdmmc-overview SD/MMC Driver Overview
 *
 * This is a driver for interfacing SD and MMC cards. It provides
 * an asynchronous interface against the application level.
 *
 * The following diagram is a high-level overview of the SD/MMC driver.  The
 * "SD/MMC block device" implements the standard block_device interface.
 * The "SD/MMC request interface" is the external interface, and it's
 * conforming to the asynchronous interface design (see \ref
 * Async-architecture). The "SD/MMC probe engine" is a task running in a
 * workqueue probing for presense of cards.
 *
 * \dot
	digraph sdmmcarch {
		node [shape=none];
		node [fontname="FreeSans"];
		block [label="SD/MMC block device", shape="box"];
		{ rank=same;
			sdmmc [label=<
<table width="80%" border="0" cellborder="1" cellspacing="0" cellpadding="8">
  <tr><td port="if">SD/MMC request interface</td></tr>
  <tr><td port="slot">SD/MMC slot(s)</td></tr>
  <tr><td port="host">SD/MMC host driver</td></tr>
</table>>];
			probe [label="SD/MMC probe engine", shape="box"];
		};
		block -> sdmmc:if [dir="both"];
		sdmmc:if -> probe [dir="both"];
		sdmmc:slot -> probe [dir="both"];
	}
 * \enddot
 *
 * \section sdmmc-init SD/MMC init
 *
 * The SD/MMC driver needs to be initialized before use and this is done with
 * the following function. This function will return a sdmmc_host structure.
 * - sdmmc_host_init(): \copybrief sdmmc_host_init()
 *
 * \section sdmmc-probe SD/MMC card probing
 *
 * sdmmc_host contains one or two sdmmc_slot depending on the configuration.
 * And the following funtion starts a probe task for the specified slot. This
 * function takes slot, workqueue to use and callback for events as arguments.
 * - sdmmc_slot_probe_init(): \copybrief sdmmc_slot_probe_init()
 *
 * \section sdmmc-request SD/MMC request management
 *
 * For general introduction to asynchronous request management see
 * Async-architecture.
 *
 * A sdmmc_request contains parts of the typical data for a communication
 * sequence against a SD or MMC card. One of the field is required and that is
 * the command (sdmmc_request::cmd). Other optional fields are:
 */

