/**
 * \file
 *
 * \brief Advanced Encryption Standard (AES) driver documentation
 *
 * This file contains an overview of the AES driver. It does not contain
 * any code.
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 * Atmel AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * \page crypto-overview Cryptography overview
 *
 * Cryptography is the practice and study of hiding information. The word
 * cryptography origins from the Greek words kryptos (hidden, secret) and
 * gráphõ (I write). Today huge amounts of sensitive information is stored and
 * transmitted electronically, and the need to keep this information secure
 * has resulted in several strong encryption standards.
 *
 * \section aes-overview The Advanced Encryption Standard
 *
 * One of these standards is the Advanced Encryption Standard (AES) developed
 * by Joan Daemen and Vincent Rijmen in cooperation with the US government. It
 * consists of three block chipers, AES-128, AES-192 and AES-256, which
 * utilize 128-, 192- and 256-bit keys. All three chipers are considered to be
 * strong enough to withstand any brute-force attack possible with current
 * technology.
 *
 * \section aes-performance Encryption overhead and specialized hardware
 *
 * Both the encryption and decryption process require heavy computations which
 * can slow down secure communication and make secure storage media slow. One
 * way of alleviating this is to employ powerful specialized hardware in the
 * encryption and decryption process, of-loading the heavy computations from
 * the CPU and reducing latency.
 *
 * \page aes-driver The asynchronous Advanced Encryption Standard driver
 *
 * This AES driver will completely of-load the encryption and decryption
 * process from the CPU, including transmission of data to and from the AES
 * hardware module, which is taken care of by the DMA controller.
 *
 * \section aes-initialization Initialization of the AES module
 *
 * Before the AES module can start encrypting or decrypting, it has to be set
 * up and configured. Firstly, the aes_init() function have to be executed.
 * This function will set up key-size and which AES mode to use, as well as
 * allocating DMA channels for the AES hardware. Secondly, the key has to be
 * loaded with the aes_load_key() function. In addition to this, some AES
 * modes require an initialization vector to be loaded before encrypting or
 * decrypting any data. If such a mode is to be used, used the
 * aes_load_init_vector() function to load this vector.
 *
 * \section aes-encryption Using the AES driver
 *
 * When the AES module has been properly set up, it is ready to accept
 * encryption or decryption requests. Multiple requests can be submitted
 * simultaneously, but they must all be either encryption or decryption
 * requests using the same AES mode, not a mix. When all submitted requests
 * have been completed, the AES direction can be changed with the
 * aes_set_cipher() function. In order to change AES mode, the module has to be
 * freed, and reinitialized.
 *
 * \section aes-request The AES request
 *
 * The space needed by an AES request is allocated by calling
 * aes_alloc_request(). The request is then prepared with
 * aes_prepare_request(), and submitted to the driver with
 * aes_submit_request(). After it has completed, it can be reused by running
 * aes_prepare_request() and aes_submit_request() again. If a callback should
 * be called when the request completes, the callback aes_request::req_done
 * and a context pointer aes_request::context must be set before submitting
 * the request. When reusing a request, it is only necessary to set these
 * parameters the first time. When a request is not needed anymore, the memory
 * it occupies should be freed with aes_free_request().
 */
