obj-$(CONFIG_CPU_AT32AP7200)	+= boot/standalone/start-at32ap7200.o
obj-$(CONFIG_CPU_AT32UC3A3)	+= boot/standalone/start-at32uc3a3.o
ldscript-y			:= boot/standalone/link.lds

ifdef CONFIG_APPLICATION_LMA
bootimg-y			+= trampoline.elf trampoline.bin

trampoline-obj-y		:= boot/standalone/trampoline.o
trampoline-ldscript-y		:= boot/standalone/trampoline.lds
trampoline-ldflags		:= -T $(trampoline-ldscript-y)

quiet_cmd_ld_tramp	= LD      $@
      cmd_ld_tramp	= $(LD) $(trampoline-ldflags) -o $@ $(trampoline-obj-y)

trampoline.elf: $(trampoline-obj-y) $(trampoline-ldscript-y)
	$(call cmd,ld_tramp)

OBJCOPYFLAGS_trampoline.bin	+= -O binary
trampoline.bin: trampoline.elf
	$(call cmd,objcopy)
endif

bootimg-y			+= $(app).bin
OBJCOPYFLAGS_$(app).bin		+= -O binary

$(app).bin: $(appimg)
	$(call cmd,objcopy)

bootimg-y			+= $(app).hex
OBJCOPYFLAGS_$(app).hex		+= -O ihex

$(app).hex: $(appimg)
	$(call cmd,objcopy)
