/**
 * \file
 *
 * \brief Initialization code for the ATEVK1104 board
 *
 * - Compiler:           IAR EWAVR32 and GNU GCC for AVR32
 * - Supported devices:  AT32UC3A3
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 * Atmel AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
#include <board/dataflash.h>
#include <board/init.h>
#include <board/sdmmc.h>
#include <chip/portmux.h>
#include <spi/spi.h>

void board_init(void)
{
	/* LEDs */
	portmux_select_gpio(PORTMUX_PORT_C, 1 << 3,
			PORTMUX_DIR_OUTPUT | PORTMUX_INIT_HIGH);
	portmux_select_gpio(PORTMUX_PORT_X0, 1 << 5 | 1 << 6 | 1 << 9,
			PORTMUX_DIR_OUTPUT | PORTMUX_INIT_HIGH);

	/* USART interface to board controller */
	portmux_enable_usart(1, PORTMUX_USART_TX | PORTMUX_USART_RX, 0);

	/* TWI interface to extension header J24 and audio amp U11 */
	portmux_enable_twi(0, 0);

	/* SPI interface */
	portmux_enable_spi(BOARD_DATAFLASH_SPI_PORT, PORTMUX_DRIVE_MIN);
	portmux_enable_spi_cs(BOARD_DATAFLASH_CS_PIN);

	/* MMC/SDCard slot A */
	portmux_enable_mmci(0, 0, PORTMUX_MMCI_8BIT | PORTMUX_MMCI_EXT_PULLUP,
			PORTMUX_DRIVE_LOW);
	portmux_select_gpio_pin(BOARD_MCISLOT_A_CD,
			PORTMUX_DIR_INPUT | PORTMUX_PULL_UP);
	portmux_select_gpio_pin(BOARD_MCISLOT_A_WP,
			PORTMUX_DIR_INPUT | PORTMUX_PULL_UP);

	/* MMC/SDCard slot B may conflict with Nexus trace interface */
#ifdef CONFIG_SDMMC_MCIHOST_SLOT_B
	portmux_enable_mmci(0, 1, PORTMUX_MMCI_4BIT | PORTMUX_MMCI_EXT_PULLUP,
			PORTMUX_DRIVE_LOW);
	portmux_select_gpio_pin(BOARD_MCISLOT_B_CD,
			PORTMUX_DIR_INPUT | PORTMUX_PULL_UP);
	portmux_select_gpio_pin(BOARD_MCISLOT_B_WP,
			PORTMUX_DIR_INPUT | PORTMUX_PULL_UP);
#endif
}
