/**
 * \file
 *
 * \brief Optimized strcmp() implementation for AVR32
 *
 * - Compiler:           GNU GCC for AVR32
 * - Supported devices:  All AVR32 devices
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 * Atmel AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

#define s1 r12
#define s2 r11
#define len r10

	.text
	.global strcmp
	.type	strcmp, @function
	.align	2
strcmp:
	mov	r8, 3
	tst	s1, r8
	brne	.Lunaligned_s1
	tst	s2, r8
	brne	.Lunaligned_s2

1:	ld.w	r8, s1++
	ld.w	r9, s2++
	cp.w	r8, r9
	brne	2f
	tnbz	r8
	brne	1b
	retal	0

2:	bfextu	r12, r8, 24, 8
	bfextu	r11, r9, 24, 8
	sub	r12, r11
	retne	r12
	cp.w	r11, 0
	reteq	0
	bfextu	r12, r8, 16, 8
	bfextu	r11, r9, 16, 8
	sub	r12, r11
	retne	r12
	cp.w	r11, 0
	reteq	0
	bfextu	r12, r8, 8, 8
	bfextu	r11, r9, 8, 8
	sub	r12, r11
	retne	r12
	cp.w	r11, 0
	reteq	0
	bfextu	r12, r8, 0, 8
	bfextu	r11, r9, 0, 8
	sub	r12, r11
	retal	r12

.Lunaligned_s1:
3:	tst	s1, r8
	breq	4f
	ld.ub	r10, s1++
	ld.ub	r9, s2++
	sub	r10, r9
	retne	r10
	cp.w	r9, 0
	brne	3b
	retal	r10

4:	tst	s2, r8
	breq	1b

.Lunaligned_s2:
	/*
	 * s1 and s2 can't both be aligned, and unaligned word loads
	 * can trigger spurious exceptions if we cross a page boundary.
	 * Do it the slow way...
	 */
1:	ld.ub	r8, s1++
	ld.ub	r9, s2++
	sub	r8, r9
	retne	r8
	cp.w	r9, 0
	brne	1b
	retal	0

	.size	strcmp, . - strcmp

	.weak	strcoll
	strcoll	= strcmp
