/**
 * \file
 *
 * \brief Optimized memchr() implementation for AVR32
 *
 * - Compiler:           GNU GCC for AVR32
 * - Supported devices:  All AVR32 devices
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 * Atmel AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

	.section .text.memchr,"ax",@progbits
	.global	memchr
	.type	memchr,@function
memchr:
	bfins	r11, r11, 8, 8
	bfins	r11, r11, 16, 16

	mov	r9, 3
	tst	r12, r9
	brne	.Lunaligned_str

.Laligned_str:
1:	sub	r10, 4
	brlt	.Lend_of_string
	ld.w	r8, r12++
	psub.b	r9, r8, r11
	tnbz	r9
	brne	1b

	/* Got it, now figure out the exact byte */
	sub	r12, 4
	bfextu	r8, r9, 24, 8
	reteq	r12

	sub	r12, -1
	bfextu	r8, r9, 16, 8
	reteq	r12

	sub	r12, -1
	bfextu	r8, r9, 8, 8
	reteq	r12

	sub	r12, -1
	retal	r12

.Lend_of_string:
	sub	r10, -4
	reteq	0

1:	ld.ub	r8, r12[0]
	cp.b	r8, r11
	reteq	r12
	sub	r12, -1
	sub	r10, 1
	brne	1b

	retal	0

.Lunaligned_str:
1:	sub	r10, 1
	retlt	0
	ld.ub	r8, r12[0]
	cp.b	r8, r11
	reteq	r12
	sub	r12, -1
	tst	r12, r9
	brne	1b

	rjmp	.Laligned_str

	.size	memchr, . - memchr
