/**
 * \file
 *
 * \brief Application-specific USB configuration parameters
 *
 * - Compiler:           IAR EWAVR32 and GNU GCC for AVR32
 * - Supported devices:  All devices with a USB Controller
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 * Atmel AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
#ifndef APP_CONFIG_USB_H_INCLUDED
#define APP_CONFIG_USB_H_INCLUDED

#include <app/version.h>

/** \brief Number of struct usb_request objects in the request pool */
#define CONFIG_USB_NR_REQUESTS			4

//@{
/** \brief USB device descriptor definitions */
#define CONFIG_USB_FUNC_DEVICE_CLASS		0x00
#define CONFIG_USB_FUNC_DEVICE_SUBCLASS		0x00
#define CONFIG_USB_FUNC_DEVICE_PROTOCOL		0x00
#define CONFIG_USB_FUNC_VENDOR_ID		0x03eb	/* Atmel Corp. */
#define CONFIG_USB_FUNC_PRODUCT_ID		0x2112
#define CONFIG_USB_FUNC_MAJOR_VERSION		0
#define CONFIG_USB_FUNC_MINOR_VERSION		1
#define CONFIG_USB_FUNC_NR_CONFIGURATIONS	1
#define CONFIG_USB_FUNC_MAXPACKETSIZE0		64
//@}

/** \brief wMaxPacketSize for ep0 */

//@{
/** \brief USB device interface IDs */
#define CONFIG_MSC_BULK_INTERFACE_ID		0
//@}

//@{
/** \brief USB device endpoint IDs */
#define CONFIG_MSC_BULK_IN_EP			1
#define CONFIG_MSC_BULK_OUT_EP			2
#define CONFIG_USBB_NR_EP			3
//@}

/** \brief Number of banks for the mass storage bulk endpoints */
#define CONFIG_MSC_BULK_NR_BANKS		1
/** \brief Vendor ID in INQUIRY response (8 bytes) */
#define CONFIG_MSC_INQ_VENDOR_ID			\
	'A', 't', 'm', 'e', 'l', ' ', ' ', ' '
/** \brief Product ID in INQUIRY response (16 bytes) */
#define CONFIG_MSC_INQ_PRODUCT_ID			\
	'U', 'S', 'B', ' ', 'M', 'a', 's', 's',		\
	' ', 'S', 't', 'o', 'r', 'a', 'g', 'e'
/** \brief Product Version in INQUIRY response (4 bytes) */
#define CONFIG_MSC_INQ_PRODUCT_VERSION			\
	'0' + 0, '.', '0' + 1, ' '

extern const char *get_serial_number(void);

/** \brief Number of DMA descriptors in the pool */
#define CONFIG_USBB_NR_DMA_DESCRIPTORS		16

#define CONFIG_UDC_HIGH_SPEED		1
#define CONFIG_UDC_FULL_SPEED		1

#endif /* APP_CONFIG_USB_H_INCLUDED */
