/*This file is prepared for Doxygen automatic documentation generation.*/
//! \file *********************************************************************
//!
//! \brief This file contains the function declarations for usb dfu task application
//!
//! - Compiler:           IAR EWAVR and GNU GCC for AVR
//! - Supported devices:  AT90USB1287, AT90USB1286, AT90USB647, AT90USB646
//!
//! \author               Atmel Corporation: http://www.atmel.com \n
//!                       Support and FAQ: http://support.atmel.no/
//!
//! ***************************************************************************

/* Copyright (c) 2009 Atmel Corporation. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an Atmel
 * AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE EXPRESSLY AND
 * SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _HOST_DFU_TASK_H_
#define _HOST_DFU_TASK_H_

//_____ I N C L U D E S ____________________________________________________


#include "config.h"

//_____ M A C R O S ________________________________________________________


#define DFU_DETACH      0x00
#define DFU_DNLOAD      0x01
#define DFU_UPLOAD      0x02
#define DFU_GETSTATUS   0x03
#define DFU_CLRSTATUS   0x04
#define DFU_GETSTATE    0x05
#define DFU_ABORT       0x06

#define RECORD_MARK     ':'
#define DATA_RECORD     0x00
#define PAGE_RECORD     0x04

#define ATMEL_VID       VID_ATMEL
#define AT90DFU_PID     PID_AT90USB128_DFU

#define MAX_DATA_PER_RECORD   16


#define Dfu_download(n)                    (usb_request.bmRequestType = USB_SETUP_SET_CLASS_INTER,\
                                           usb_request.bRequest      = DFU_DNLOAD,\
                                           usb_request.wValue        = 0,\
                                           usb_request.wIndex        = 0,\
                                           usb_request.wLength       = n,\
                                           usb_request.uncomplete_read = FALSE,\
                                           host_send_control(data_stage))

#define Dfu_upload(n)                      (usb_request.bmRequestType = USB_SETUP_GET_CLASS_INTER,\
                                           usb_request.bRequest      = DFU_UPLOAD,\
                                           usb_request.wValue        = 0,\
                                           usb_request.wIndex        = 0,\
                                           usb_request.wLength       = n,\
                                           usb_request.uncomplete_read = FALSE,\
                                           host_send_control(data_stage))


#define Dfu_get_status()                  (usb_request.bmRequestType = USB_SETUP_GET_CLASS_INTER,\
                                           usb_request.bRequest      = DFU_GETSTATUS,\
                                           usb_request.wValue        = 0,\
                                           usb_request.wIndex        = 0,\
                                           usb_request.wLength       = 6,\
                                           usb_request.uncomplete_read = FALSE,\
                                           host_send_control(data_stage))

#define Dfu_read_manuf_id()               (  data_stage[0]=0x05,\
                                             data_stage[1]=0x01,\
                                             data_stage[2]=0x30,\
                                                Dfu_download(3),\
                                                Dfu_upload(1))

#define Dfu_erase()                       (  data_stage[0]=0x04,\
                                             data_stage[1]=0x00,\
                                             data_stage[2]=0xFF,\
                                                Dfu_download(3))

#define Dfu_set_page(n)                   (  data_stage[0]=0x06,\
                                             data_stage[1]=0x03,\
                                             data_stage[2]=0x00,\
                                             data_stage[3]=n,\
                                                Dfu_download(4))

#define Dfu_start_appli(n)                (  data_stage[0]=0x04,\
                                             data_stage[1]=0x03,\
                                             data_stage[2]=0x00,\
                                                Dfu_download(3),\
                                                Dfu_get_status())

#define FIRMWARE_NAME   "FIRMWARE.HEX"
#define SIZE_BUF_STR    36




//_____ D E C L A R A T I O N S ____________________________________________

extern U8  dfu_connected;

void dfu_read(U16 start,U16 end,U8 *buf);
void dfu_prog(U16 start,U16 end,U8 *buf);
U8 dfu_load_hex(void);
void dfu_flush_prog(void);
U8 ascii_to_bin (U8 b);

#endif /* _HOST_DFU_TASK_H_ */
