/*This file is prepared for Doxygen automatic documentation generation.*/
//! \file *********************************************************************
//!
//! \brief Main for USB application.
//!
//! - Compiler:           IAR EWAVR and GNU GCC for AVR
//! - Supported devices:  AT90USB1287, AT90USB1286, AT90USB647, AT90USB646
//!
//! \author               Atmel Corporation: http://www.atmel.com \n
//!                       Support and FAQ: http://support.atmel.no/
//!
//! ***************************************************************************
//!
//! @mainpage AT90USBxxx Dual role demonstration with file system
//!
//! @section intro License
//! Use of this program is subject to Atmel's End User License Agreement.
//!
//! Please read file  \ref lic_page for copyright notice.
//!
//! @section install Description
//! This embedded application source code illustrates how to implement a dual role application with
//! the AT90USBxxx controller.
//!
//! As the AT90USBxxx implements  a device/host usb controller, the embedded application can operates
//! in one of the following usb operating modes:
//! - USB device
//! - USB reduced host controller
//!
//! @section src_code About the source code
//! This source code is usable with the following compilers:
//! - IAR Embedded Workbench (5.11A and higher)
//! - AVRGCC (WinAVR 20080411 and higher).
//!
//! Support for other compilers may required modifications or attention for:
//! - compiler.h file 
//! - special registers declaration file
//! - interrupt subroutines declarations
//!
//! @section Revision Revision
//!
//! @par V2.0.8
//!
//! USB Device:
//! - Class MSC:
//!   - Add MSC compliance with Linux 2.4 kernel
//!
//! USB Host:
//! - Class MSC:
//!   - Add read/write USB command for large block
//!
//! Ushell:
//! - Add new command to perform transfer
//! - Fix and enable history of Ushell
//!
//! FileSystem:
//! - Fix bug in routine which check the end of cluster list
//! - Fix format FAT32
//! - Improve format time
//!
//! @par V2.0.7
//!
//! ** MAJOR changes :
//! - Add feature "firmware upgrade via U-Disk" (for IAR compiler only), See AppNote AVR916
//! - New ushell
//!
//! ** Other changes
//!
//! USB DEVICE Stack:
//! - Class MSC:
//!   - Improve MSC compliance
//!   - Add write Protect Management under MAC OS
//! - Detach behavior in mode self power
//!
//! USB HOST Stack:
//! - Improve Device MSC detection
//! - Improve Write protection detection on device MSC
//!
//! @par V2.0.6
//! 
//! USB Stack - Host mode :
//! - improve behavior of MS driver with HUB
//! - Update MS driver to support the write mode with sector sizes other than 512 bytes (see USB_SUPPORT_MS_SECTOR_WR_MAX)
//! - Fix read routine with a U-Disk sector !=512B
//!
//! USB Stack - Device mode :
//! - Fix bug in MSC driver to support Vista and Windows Seven
//!
//! File System:
//! - Fix nav_dir_name() routine
//!
//! @par V2.0.5
//!
//! USB Stack:
//! - Fix bug on stall management with dual banks
//! - Improve device disconnection detection in USB host mode
//! - Fix bug about back drive voltage on D+ after VBus disconnect (USB Certification)
//! - New MS driver for USB host:
//!   - support multi LUN like multi card reader
//!   - fix bug in case of different plug
//!   - improve disconnection detection
//!   - support disk with sector size different of 512B (read only)
//! 
//! File System:
//! - Fix bug on feature get free space on FAT32
//! - Fix bug in case of memory full during a path creation
//! - Fix bug in case of mode "nav_single" (file or dir) enable
//! - Add cmd, get partition size
//!
//! @par V2.0.4
//!
//! USB Stack :
//! - improve USB chap9 & MSC compliance
//! - Fix USB constant about Device Status
//! - Add a new sub class for MassStorage
//! 
//! New watchdog driver
//!
//! DataFlash driver :
//! - Fix bug in I/O initialization routine
//! 
//! File System :
//! - Split write command during copy file to support bad U-Disk
//! - Update short name creation routine for more compliant with FAT32 white paper
//! - improve ushell_task.c behavior
//! 
//! @par V2.0.3
//!
//! - Move VBus interrupt to VBus pooling
//!
//! @par V2.0.2
//!
//! Improvemnt:
//! - Add three possibilities for SN on USB (No SN/Constant SN/Unique SN)
//! - Add dual bank in USB host mode
//! - Add the switch USB mode by software (no use HW reset)
//! - Improvement ushell task
//! - Create a generic copy routine
//!
//! @par V2.0.1
//!
//! Fix:
//! - write command on host ms (Remove SOF flag test in host_write_10_ram)
//! New:
//! - Add USBKEY driver in package
//! - Add modify generic defines from board driver
//! - Add USB Write Protection management on DataFlash
//! 
//! @par V2.0.0
//!
//! - First release
//! 
//! @section sample About the sample application
//! By default the demonstration is preconfigured for dual role USB application.
//! It means that the code generated allows to operate as a device or a host depending on the USB ID pin:
//! - Attached to a mini B plug (ID pin unconnected) the application will be used in the device operating mode.
//! Thus the application can be connected to a system host (PC) to operate as USB Device Mass Storage (removable drive).
//!
//! @image html appli_pc.gif
//! - Attached to a mini A plug (ID pin tied to ground) the application operates in reduced host mode.
//! This mode allows to connect a USB mass storage device
//!
//! @image html appli_host.gif
//! - In both modes, the STK525 can be connected to a serial terminal, where the user can acess a simple 
//! command line interperter (ushell) to perform file system access.
//! To use the simple  shell application, connect the STK525 to a serial terminal emulator
//! (like Hyperterminal under windows systems). The serial port settings are:
//!  - 57600 bauds
//!  - 8bits data, no parity
//!  - no flow control
//! To use the application, the SK525 should be configured to be self powered (see STK525
//! hardware manual).
//!
//! @section device Using the USB device mode
//! Connect the STK525 to a PC host system with a miniB (STK525 side) to plugA (PC host) cable
//! - A removable drive allows to read/write files on the on-board data flash memory.
//!
//! @section host_usage Using the USB host mode
//! - Connected to a USB Mass Storage Device (MSD), files can be exchange with the  on-board data flash disk and the MSD.
//!   - The right direction of the joystick allows to read the 
//!content of a MSD "OUT" directory and to write it to an on-board data flash "IN" directory.
//!   - The left direction of the joystick allows to write the 
//!content of an on-board data flash "OUT" directory to a MSD "IN" directory.
//!
//! @section ushell Using the shell terminal
//! Connected to a serial terminal emulator the Usheel command line interpreter allows to:
//! - Navigate in the file system (both on-board dataflash and a USB mass storage device connected to the USB host interface).
//! The following commands are supported:
//!   -  a: , b: ... goto selected drive            
//!   -  cd dirname                                 
//!   -  ls                                         
//!   -  touch filename                             
//!   -  append filename                            
//!   -  mark: bookmark current directory           
//!   -  cp filename: copy filename to bookmark     
//!   -  rm filename: erase file or empty directory 
//!   -  format drivename, with drivename: a, b...  
//!   -  deltree dirname                            
//!   -  cat filename                               
//!   -  cd..                                       
//!   -  mount disk(a,b,..)                         
//!   -  mkdir dirname                              
//!   -  disk: get number of drives                 
//!   -  goto: goto bookmark                        
//!   -  df: get free space information             
//!   -  cat filename                               
//!   -  rm*: rm *                                         
//! - Get information about the connected device and misc commands
//!   -  lsusb
//!   -  suspend: suspend USB bus activity
//!   -  resume: resume USB bus activity
//!   -  reboot: reset the application
//! 
//! For more information about File System module see \subpage FileSystem
//!
//! @section arch Architecture
//! As illustrated in the figure bellow, the application entry point is located is the main.c file.
//! The main function first performs the initialization of a scheduler module and then runs it in an infinite loop.
//! The scheduler is a simple infinite loop calling all its tasks defined in the conf_scheduler.h file.
//! No real time schedule is performed, when a task ends, the scheduler calls the next task defined in
//! the configuration file (conf_scheduler.h).
//!
//! The sample dual role application is based on several different tasks:
//! - The usb_task  (usb_task.c associated source file), is the task performing the USB low level
//! enumeration process in device or host mode.
//! Once this task has detected that the usb connection is fully operationnal, it updates different status flags
//! that can be check within the high level application tasks.
//! - The storage task performs SCSI bulk only protocol decoding and performs flash memory access.
//! - The host_ms_task manages the Device Mass Storage interfaceconnected 
//! - The ushell_task manages the terminal commands process
//!
//! \image html arch_full.gif
//!
//! ***************************************************************************

/* Copyright (c) 2009 Atmel Corporation. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an Atmel
 * AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE EXPRESSLY AND
 * SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

//_____  I N C L U D E S ___________________________________________________

#include "config.h"
#include "modules/scheduler/scheduler.h"
#include "lib_mcu/wdt/wdt_drv.h"
#include "lib_mcu/power/power_drv.h"

//_____ M A C R O S ________________________________________________________

//_____ D E F I N I T I O N S ______________________________________________

int main(void)
{   
   wdtdrv_disable();
   Clear_prescaler();
   scheduler();
   return 0;
}

//! \name Procedure to speed up the startup code
//! This one increment the CPU clock before RAM initialisation
//! @{
#ifdef  __GNUC__
// Locate low level init function before RAM init (init3 section)
// and remove std prologue/epilogue
char __low_level_init(void) __attribute__ ((section (".init3"),naked));
#endif

#ifdef __cplusplus
extern "C" {
#endif
char __low_level_init()
{
  Clear_prescaler();
  return 1;
}
#ifdef __cplusplus
}
#endif
//! @}

