/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.servlet.utility;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderUtil;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.servlet.utility.NullOutputStream;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class UmlExtractor {
    public static String getUmlSource(String source) {
        String uml;
        String text;
        try {
            text = URLDecoder.decode(source, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            text = "' invalid encoded string";
        }
        Transcoder transcoder = TranscoderUtil.getDefaultTranscoder();
        try {
            text = transcoder.decode(text);
        }
        catch (IOException ioe) {
            text = "' unable to decode string";
        }
        if (text.startsWith("@start")) {
            uml = text;
        } else {
            StringBuilder plantUmlSource = new StringBuilder();
            plantUmlSource.append("@startuml\n");
            plantUmlSource.append(text);
            if (!text.endsWith("\n")) {
                plantUmlSource.append("\n");
            }
            plantUmlSource.append("@enduml");
            uml = plantUmlSource.toString();
        }
        return uml;
    }

    public static String extractMap(String uml) throws IOException {
        return UmlExtractor.extractMap((String)uml, (FileFormat)FileFormat.PNG);
    }

    public static String extractMap(String uml, FileFormat fileFormat) throws IOException {
        Diagram diagram = ((BlockUml)new SourceStringReader(uml).getBlocks().get(0)).getDiagram();
        ImageData map = diagram.exportDiagram((OutputStream)new NullOutputStream(), 0, new FileFormatOption(fileFormat, false));
        if (map.containsCMapData()) {
            return map.getCMapData("plantuml");
        }
        return null;
    }

    static {
        OptionFlags.ALLOW_INCLUDE = false;
        if ("true".equalsIgnoreCase(System.getenv("ALLOW_PLANTUML_INCLUDE"))) {
            OptionFlags.ALLOW_INCLUDE = true;
        }
    }
}

