/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import javax.imageio.IIOException;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.servlet.DiagramResponse;
import net.sourceforge.plantuml.servlet.utility.UmlExtractor;
import net.sourceforge.plantuml.servlet.utility.UrlDataExtractor;

public abstract class UmlDiagramService
extends HttpServlet {
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String uml;
        String url = request.getRequestURI();
        String encoded = UrlDataExtractor.getEncodedDiagram((String)url, (String)"");
        int idx = UrlDataExtractor.getIndex((String)url, (int)0);
        try {
            uml = UmlExtractor.getUmlSource((String)encoded);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.sendError(400, "Bad Request");
            return;
        }
        this.doDiagramResponse(request, response, uml, idx);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int idx = UrlDataExtractor.getIndex((String)request.getRequestURI(), (int)0);
        StringBuilder uml = new StringBuilder();
        try (BufferedReader in = request.getReader();){
            String line;
            while ((line = in.readLine()) != null) {
                uml.append(line).append('\n');
            }
        }
        this.doDiagramResponse(request, response, uml.toString(), idx);
    }

    private void doDiagramResponse(HttpServletRequest request, HttpServletResponse response, String uml, int idx) throws IOException {
        DiagramResponse dr = new DiagramResponse(response, this.getOutputFormat(), request);
        try {
            dr.sendDiagram(uml, idx);
        }
        catch (IIOException iIOException) {
            // empty catch block
        }
    }

    public abstract FileFormat getOutputFormat();

    static {
        OptionFlags.ALLOW_INCLUDE = false;
        if ("true".equalsIgnoreCase(System.getenv("ALLOW_PLANTUML_INCLUDE"))) {
            OptionFlags.ALLOW_INCLUDE = true;
        }
    }
}

