/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.servlet;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.api.PlantumlUtils;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderUtil;
import net.sourceforge.plantuml.png.MetadataTag;
import net.sourceforge.plantuml.servlet.utility.Configuration;
import net.sourceforge.plantuml.servlet.utility.UmlExtractor;
import net.sourceforge.plantuml.servlet.utility.UrlDataExtractor;

/*
 * Exception performing whole class analysis ignored.
 */
public class PlantUmlServlet
extends HttpServlet {
    private static final String DEFAULT_ENCODED_TEXT = "SyfFKj2rKt3CoKnELR1Io4ZDoSa70000";
    private static final Pattern URL_PATTERN = Pattern.compile("^.*[^a-zA-Z0-9\\-\\_]([a-zA-Z0-9\\-\\_]+)");

    public static String stringToHTMLString(String string) {
        int c;
        StringBuffer sb = new StringBuffer(string.length());
        int length = string.length();
        for (int offset = 0; offset < length; offset += Character.charCount(c)) {
            c = string.codePointAt(offset);
            if (c == 32) {
                sb.append(' ');
                continue;
            }
            if (c == 34) {
                sb.append("&quot;");
                continue;
            }
            if (c == 38) {
                sb.append("&amp;");
                continue;
            }
            if (c == 60) {
                sb.append("&lt;");
                continue;
            }
            if (c == 62) {
                sb.append("&gt;");
                continue;
            }
            if (c == 13) {
                sb.append("\r");
                continue;
            }
            if (c == 10) {
                sb.append("\n");
                continue;
            }
            int ci = 0xFFFFFF & c;
            if (ci < 160) {
                sb.append((char)c);
                continue;
            }
            sb.append("&#");
            sb.append(ci);
            sb.append(';');
        }
        return sb.toString();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setCharacterEncoding("UTF-8");
        String text = this.getText(request).trim();
        if (text.isEmpty()) {
            this.redirectNow(request, response, "SyfFKj2rKt3CoKnELR1Io4ZDoSa70000");
            return;
        }
        int idx = UrlDataExtractor.getIndex((String)request.getRequestURI());
        this.prepareRequestForDispatch(request, text, idx);
        RequestDispatcher dispatcher = request.getRequestDispatcher("/index.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String encoded;
        request.setCharacterEncoding("UTF-8");
        int idx = UrlDataExtractor.getIndex((String)request.getRequestURI());
        try {
            String text = this.getText(request).trim();
            encoded = this.getTranscoder().encode(text);
        }
        catch (Exception e) {
            encoded = "SyfFKj2rKt3CoKnELR1Io4ZDoSa70000";
            e.printStackTrace();
        }
        this.redirectNow(request, response, encoded, Integer.valueOf(idx));
    }

    private String getText(HttpServletRequest request) throws IOException {
        String text;
        try {
            text = this.getTextFromUrl(request);
            if (text != null && !text.isEmpty()) {
                return text;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String metadata = request.getParameter("metadata");
        if (metadata != null) {
            try (InputStream img = PlantUmlServlet.getImage((URL)new URL(metadata));){
                MetadataTag metadataTag = new MetadataTag(img, "plantuml");
                String data = metadataTag.getData();
                if (data != null) {
                    String string = data;
                    return string;
                }
            }
        }
        if ((text = request.getParameter("text")) != null && !text.isEmpty()) {
            return text;
        }
        return "";
    }

    private String getTextFromUrl(HttpServletRequest request) throws IOException {
        String encoded;
        String url = request.getRequestURI();
        if (url.contains("/uml/") && !url.endsWith("/uml/") && !(encoded = UrlDataExtractor.getEncodedDiagram((String)request.getRequestURI(), (String)"")).isEmpty()) {
            return this.getTranscoder().decode(encoded);
        }
        url = request.getParameter("url");
        if (url != null && !url.trim().isEmpty()) {
            Matcher matcher = URL_PATTERN.matcher(url);
            if (matcher.find()) {
                url = matcher.group(1);
            }
            return this.getTranscoder().decode(url);
        }
        return "";
    }

    private void prepareRequestForDispatch(HttpServletRequest request, String text, int idx) throws IOException {
        String encoded = this.getTranscoder().encode(text);
        Object index = idx < 0 ? "" : idx + "/";
        request.setAttribute("decoded", (Object)text);
        request.setAttribute("index", (Object)idx);
        request.setAttribute("showSocialButtons", (Object)Configuration.get((String)"SHOW_SOCIAL_BUTTONS"));
        request.setAttribute("showGithubRibbon", (Object)Configuration.get((String)"SHOW_GITHUB_RIBBON"));
        String hostpath = this.getHostpath(request);
        request.setAttribute("hostpath", (Object)hostpath);
        boolean hasImg = !text.isEmpty();
        request.setAttribute("hasImg", (Object)hasImg);
        request.setAttribute("imgurl", (Object)(hostpath + "/png/" + (String)index + encoded));
        request.setAttribute("svgurl", (Object)(hostpath + "/svg/" + (String)index + encoded));
        request.setAttribute("txturl", (Object)(hostpath + "/txt/" + (String)index + encoded));
        request.setAttribute("mapurl", (Object)(hostpath + "/map/" + (String)index + encoded));
        boolean hasMap = PlantumlUtils.hasCMapData((String)text);
        request.setAttribute("hasMap", (Object)hasMap);
        String map = "";
        if (hasMap) {
            try {
                map = UmlExtractor.extractMap((String)text);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        request.setAttribute("map", (Object)map);
    }

    private String getHostpath(HttpServletRequest request) {
        Object port = "";
        if (request.getScheme() == "http" && request.getServerPort() != 80 || request.getScheme() == "https" && request.getServerPort() != 443) {
            port = ":" + request.getServerPort();
        }
        String scheme = request.getScheme();
        String forwardedProto = request.getHeader("x-forwarded-proto");
        if (forwardedProto != null && !forwardedProto.isEmpty()) {
            scheme = forwardedProto;
        }
        return scheme + "://" + request.getServerName() + (String)port + request.getContextPath();
    }

    private void redirectNow(HttpServletRequest request, HttpServletResponse response, String encoded) throws IOException {
        this.redirectNow(request, response, encoded, null);
    }

    private void redirectNow(HttpServletRequest request, HttpServletResponse response, String encoded, Integer index) throws IOException {
        String result = index == null || index < 0 ? request.getContextPath() + "/uml/" + encoded : request.getContextPath() + "/uml/" + index + "/" + encoded;
        response.sendRedirect(result);
    }

    private Transcoder getTranscoder() {
        return TranscoderUtil.getDefaultTranscoder();
    }

    private static HttpURLConnection getConnection(URL url) throws IOException {
        if (url.getProtocol().startsWith("https")) {
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setReadTimeout(10000);
            con.connect();
            return con;
        }
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("GET");
        con.setReadTimeout(10000);
        con.connect();
        return con;
    }

    private static InputStream getImage(URL url) throws IOException {
        InputStream is = null;
        HttpURLConnection con = PlantUmlServlet.getConnection((URL)url);
        is = con.getInputStream();
        return is;
    }

    static {
        OptionFlags.ALLOW_INCLUDE = false;
        if ("true".equalsIgnoreCase(System.getenv("ALLOW_PLANTUML_INCLUDE"))) {
            OptionFlags.ALLOW_INCLUDE = true;
        }
    }
}

