/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.NullOutputStream;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.code.Base64Coder;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.error.PSystemError;
import net.sourceforge.plantuml.version.Version;

/*
 * Exception performing whole class analysis ignored.
 */
public class DiagramResponse {
    private static final Map<FileFormat, String> CONTENT_TYPE;
    private static final String POWERED_BY;
    private FileFormat format;
    private HttpServletRequest request;
    private HttpServletResponse response;

    public DiagramResponse(HttpServletResponse res, FileFormat fmt, HttpServletRequest req) {
        this.response = res;
        this.format = fmt;
        this.request = req;
    }

    public void sendDiagram(String uml, int idx) throws IOException {
        Diagram diagram;
        this.response.addHeader("Access-Control-Allow-Origin", "*");
        this.response.setContentType(this.getContentType());
        SourceStringReader reader = new SourceStringReader(uml);
        if (this.format == FileFormat.BASE64) {
            byte[] imageBytes;
            try (ByteArrayOutputStream outstream = new ByteArrayOutputStream();){
                reader.outputImage((OutputStream)outstream, idx, new FileFormatOption(FileFormat.PNG));
                imageBytes = outstream.toByteArray();
            }
            String base64 = Base64Coder.encodeLines((byte[])imageBytes).replaceAll("\\s", "");
            String encodedBytes = "data:image/png;base64," + base64;
            this.response.getOutputStream().write(encodedBytes.getBytes());
            return;
        }
        BlockUml blockUml = (BlockUml)reader.getBlocks().get(0);
        if (this.notModified(blockUml)) {
            this.addHeaderForCache(blockUml);
            this.response.sendError(304);
            return;
        }
        if (StringUtils.isDiagramCacheable((String)uml)) {
            this.addHeaderForCache(blockUml);
        }
        if ((diagram = blockUml.getDiagram()) instanceof PSystemError) {
            this.response.setStatus(400);
        }
        diagram.exportDiagram((OutputStream)this.response.getOutputStream(), idx, new FileFormatOption(this.format));
    }

    private boolean notModified(BlockUml blockUml) {
        String ifNoneMatch = this.request.getHeader("If-None-Match");
        long ifModifiedSince = this.request.getDateHeader("If-Modified-Since");
        if (ifModifiedSince != -1L && ifModifiedSince != blockUml.lastModified()) {
            return false;
        }
        String etag = blockUml.etag();
        if (ifNoneMatch == null) {
            return false;
        }
        return ifNoneMatch.contains(etag);
    }

    public void sendMap(String uml, int idx) throws IOException {
        Diagram diagram;
        ImageData map;
        if (idx < 0) {
            idx = 0;
        }
        this.response.setContentType(this.getContentType());
        SourceStringReader reader = new SourceStringReader(uml);
        BlockUml blockUml = (BlockUml)reader.getBlocks().get(0);
        if (StringUtils.isDiagramCacheable((String)uml)) {
            this.addHeaderForCache(blockUml);
        }
        if ((map = (diagram = blockUml.getDiagram()).exportDiagram((OutputStream)new NullOutputStream(), idx, new FileFormatOption(FileFormat.PNG, false))).containsCMapData()) {
            PrintWriter httpOut = this.response.getWriter();
            String cmap = map.getCMapData("plantuml");
            httpOut.print(cmap);
        }
    }

    public void sendCheck(String uml) throws IOException {
        this.response.setContentType(this.getContentType());
        SourceStringReader reader = new SourceStringReader(uml);
        DiagramDescription desc = reader.outputImage((OutputStream)new NullOutputStream(), new FileFormatOption(FileFormat.PNG, false));
        PrintWriter httpOut = this.response.getWriter();
        httpOut.print(desc.getDescription());
    }

    private void addHeaderForCache(BlockUml blockUml) {
        long today = System.currentTimeMillis();
        int maxAge = 432000;
        this.response.addDateHeader("Expires", today + 432000000L);
        this.response.addDateHeader("Date", today);
        this.response.addDateHeader("Last-Modified", blockUml.lastModified());
        this.response.addHeader("Cache-Control", "public, max-age=432000");
        this.response.addHeader("Etag", "\"" + blockUml.etag() + "\"");
        Diagram diagram = blockUml.getDiagram();
        this.response.addHeader("X-PlantUML-Diagram-Description", diagram.getDescription().getDescription());
        if (diagram instanceof PSystemError) {
            PSystemError error = (PSystemError)diagram;
            for (ErrorUml err : error.getErrorsUml()) {
                this.response.addHeader("X-PlantUML-Diagram-Error", err.getError());
                this.response.addHeader("X-PlantUML-Diagram-Error-Line", "" + err.getLineLocation().getPosition());
            }
        }
        DiagramResponse.addHeaders((HttpServletResponse)this.response);
    }

    private static void addHeaders(HttpServletResponse response) {
        response.addHeader("X-Powered-By", POWERED_BY);
        response.addHeader("X-Patreon", "Support us on https://plantuml.com/patreon");
        response.addHeader("X-Donate", "https://plantuml.com/paypal");
    }

    private String getContentType() {
        return (String)CONTENT_TYPE.get(this.format);
    }

    static {
        POWERED_BY = "PlantUML Version " + Version.versionString();
        OptionFlags.ALLOW_INCLUDE = false;
        if ("true".equalsIgnoreCase(System.getenv("ALLOW_PLANTUML_INCLUDE"))) {
            OptionFlags.ALLOW_INCLUDE = true;
        }
        CONTENT_TYPE = Collections.unmodifiableMap(new /* Unavailable Anonymous Inner Class!! */);
    }
}

