/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.PSystemVersion;
import net.sourceforge.plantuml.version.Version;

class LicenseWindow
extends JFrame {
    public LicenseWindow() {
        this.setIconImage(PSystemVersion.getPlantumlSmallIcon2());
        this.setTitle("Licence PlantUML (" + Version.versionString() + ")");
        this.getContentPane().add((Component)this.getNorthLabel(), "North");
        ArrayList<String> list = new ArrayList<String>(License.getCurrent().getTextFull());
        this.getContentPane().add((Component)this.getJComponent(list), "Center");
        this.getContentPane().add((Component)this.getSouthLabel(), "South");
        this.setSize(800, 600);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
    }

    private JComponent getNorthLabel() {
        JLabel text = new JLabel("PlantUML (" + Version.versionString() + ")");
        Font font = text.getFont().deriveFont(1, 20.0f);
        text.setFont(font);
        JPanel ptext = new JPanel();
        ptext.add(text);
        JLabel icon = new JLabel(new ImageIcon(PSystemVersion.getPlantumlImage()));
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)ptext, "Center");
        result.add((Component)icon, "East");
        return result;
    }

    private JComponent getSouthLabel() {
        JPanel result = new JPanel();
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LicenseWindow.this.dispose();
            }
        });
        result.add(ok);
        return result;
    }

    private JComponent getJComponent(List<String> lines) {
        StringBuilder sb = new StringBuilder("<html>");
        for (String s2 : lines) {
            sb.append(s2 + "</b></i></u>");
            sb.append("<br>");
        }
        sb.append("</html>");
        JEditorPane text = new JEditorPane("text/html", sb.toString());
        text.setEditable(false);
        CompoundBorder border = new CompoundBorder(BorderFactory.createEtchedBorder(0), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        border = new CompoundBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, this.getBackground()), border);
        text.setBorder(border);
        final JScrollPane jScrollPane = new JScrollPane(text, 22, 32);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jScrollPane.getVerticalScrollBar().setValue(0);
            }
        });
        return jScrollPane;
    }

    public static void main(String[] arg) {
        new LicenseWindow();
    }
}

