/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.timescale;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.DayOfWeek;
import net.sourceforge.plantuml.project.timescale.TimeScale;

public final class TimeScaleDailyNoWeekend
implements TimeScale {
    private final double cellWidth;
    private final Day startingDay;
    private final Map<Day, Double> startingPosition = new HashMap<Day, Double>();

    public TimeScaleDailyNoWeekend(double size, Day startingDay, double scale) {
        this.cellWidth = size * scale;
        this.startingDay = startingDay;
    }

    @Override
    public double getStartingPosition(Day instant) {
        if (instant.compareTo(this.startingDay) < 0) {
            throw new IllegalArgumentException();
        }
        Double cached = this.startingPosition.get(instant);
        if (cached != null) {
            return cached;
        }
        double result = 0.0;
        Day i = this.startingDay;
        while (i.compareTo(instant) < 0) {
            result += this.getWidth(i);
            i = i.increment();
        }
        this.startingPosition.put(instant, result);
        return result;
    }

    @Override
    public double getEndingPosition(Day instant) {
        return this.getStartingPosition(instant) + this.getWidth(instant);
    }

    @Override
    public double getWidth(Day instant) {
        DayOfWeek dayOfWeek = instant.getDayOfWeek();
        if (dayOfWeek == DayOfWeek.SATURDAY || dayOfWeek == DayOfWeek.SUNDAY) {
            return 0.0;
        }
        return this.cellWidth;
    }

    @Override
    public boolean isBreaking(Day instant) {
        return true;
    }
}

