/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.shape;

import net.sourceforge.plantuml.klimt.UShape;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;

public class UText
implements UShape {
    private final String text;
    private final FontConfiguration font;
    private final int orientation;

    public String toString() {
        return "UText[" + this.text + "]";
    }

    private UText(String text, FontConfiguration font, int orientation) {
        assert (text.indexOf(9) == -1);
        this.text = text;
        this.font = font;
        this.orientation = orientation;
    }

    public static UText build(String text, FontConfiguration font) {
        return new UText(text, font, 0);
    }

    public UText withOrientation(int orientation) {
        return new UText(this.text, this.font, orientation);
    }

    public String getText() {
        return this.text;
    }

    public FontConfiguration getFontConfiguration() {
        return this.font;
    }

    public double getDescent(StringBounder stringBounder) {
        return stringBounder.getDescent(this.font.getFont(), this.text);
    }

    public final int getOrientation() {
        return this.orientation;
    }

    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return stringBounder.calculateDimension(this.font.getFont(), this.text);
    }
}

