/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code;

import java.io.IOException;
import net.sourceforge.plantuml.code.ArobaseStringCompressor;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.code.AsciiEncoderHex;
import net.sourceforge.plantuml.code.CompressionGZip;
import net.sourceforge.plantuml.code.CompressionHuffman;
import net.sourceforge.plantuml.code.CompressionNone;
import net.sourceforge.plantuml.code.CompressionZip;
import net.sourceforge.plantuml.code.CompressionZlib;
import net.sourceforge.plantuml.code.NoPlantumlCompressionException;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderImpl;

public class TranscoderSmartProtected
implements Transcoder {
    private final Transcoder oldOne = TranscoderImpl.utf8(new AsciiEncoder(), new ArobaseStringCompressor(), new CompressionHuffman());
    private final Transcoder zlib = TranscoderImpl.utf8(new AsciiEncoder(), new ArobaseStringCompressor(), new CompressionZlib());
    private final Transcoder hexOnly = TranscoderImpl.utf8(new AsciiEncoderHex(), new ArobaseStringCompressor(), new CompressionNone());
    private final Transcoder zip = TranscoderImpl.utf8(new AsciiEncoder(), new ArobaseStringCompressor(), new CompressionZip());
    private final Transcoder gzip = TranscoderImpl.utf8(new AsciiEncoder(), new ArobaseStringCompressor(), new CompressionGZip());

    @Override
    public String decode(String code) throws NoPlantumlCompressionException {
        if (code.startsWith("~0")) {
            return this.decodeZlib(code.substring(2));
        }
        if (code.startsWith("~1")) {
            return this.decodeHuffman(code.substring(2));
        }
        if (code.startsWith("~h")) {
            return this.hexOnly.decode(code.substring(2));
        }
        if (code.startsWith("~g")) {
            return this.gzip.decode(code.substring(2));
        }
        if (code.startsWith("~zip~")) {
            return this.zip.decode(code.substring(5));
        }
        return this.decodeZlib(code);
    }

    private String decodeZlib(String code) {
        try {
            return this.zlib.decode(code);
        }
        catch (Exception ex) {
            return this.textProtectedDeflate2(code);
        }
    }

    private String decodeHuffman(String code) {
        try {
            return this.oldOne.decode(code);
        }
        catch (Exception ex) {
            return this.textProtectedHuffman(code);
        }
    }

    private String textProtectedHuffman(String code) {
        StringBuilder result = new StringBuilder();
        this.appendLine(result, "@startuml");
        this.appendLine(result, "legend");
        this.appendLine(result, "The plugin you are using seems to generated a bad URL.");
        this.appendLine(result, "This URL does not look like HUFFMAN data.");
        this.appendLine(result, "");
        this.appendLine(result, "See https://plantuml.com/pte");
        this.appendLine(result, "");
        this.appendLine(result, "You may contact the PlantUML team at plantuml@gmail.com");
        this.appendLine(result, "But you should also probably contact the plugin authors you are currently using and send them this image");
        this.appendLine(result, "");
        this.appendLine(result, "For the record, here is your data:");
        this.appendLine(result, "");
        this.appendURL(result, code);
        this.appendLine(result, "endlegend");
        this.appendLine(result, "@enduml");
        return result.toString();
    }

    private String textProtectedDeflate2(String code) {
        StringBuilder result = new StringBuilder();
        String codeshort = code.length() > 30 ? code.substring(0, 30) + "..." : code;
        this.appendLine(result, "@startuml");
        this.appendLine(result, "legend");
        this.appendLine(result, "The plugin you are using seems to generated a bad URL.");
        this.appendLine(result, "This URL does not look like DEFLATE data.");
        this.appendLine(result, "It looks like your plugin is using HUFFMAN encoding.");
        this.appendLine(result, "");
        this.appendLine(result, "This means you have now to add an header ~1 to your data. For example, you have to change:");
        this.appendLine(result, "http://www.plantuml.com/plantuml/png/" + codeshort);
        this.appendLine(result, "to");
        this.appendLine(result, "http://www.plantuml.com/plantuml/png/~1" + codeshort);
        this.appendLine(result, "");
        this.appendLine(result, "It will work this way");
        this.appendLine(result, "You may contact the PlantUML team at plantuml@gmail.com");
        this.appendLine(result, "But you should also probably contact the plugin authors you are currently using and send them this image");
        this.appendLine(result, "");
        this.appendLine(result, "For the record, here is your data:");
        this.appendLine(result, "");
        this.appendURL(result, code);
        this.appendLine(result, "endlegend");
        this.appendLine(result, "@enduml");
        return result.toString();
    }

    private void appendURL(StringBuilder result, String url) {
        while (url.length() > 80) {
            this.appendLine(result, url.substring(0, 80));
            url = url.substring(80);
        }
        if (url.length() > 0) {
            this.appendLine(result, url);
        }
    }

    private void appendLine(StringBuilder sb, String s2) {
        sb.append(s2);
        sb.append("\n");
    }

    @Override
    public String encode(String text) throws IOException {
        return this.zlib.encode(text);
    }
}

