/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cheneer.command;

import java.util.ArrayList;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.abel.LinkArg;
import net.sourceforge.plantuml.cheneer.ChenEerDiagram;
import net.sourceforge.plantuml.cheneer.command.CommandCreateEntity;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.decoration.LinkDecor;
import net.sourceforge.plantuml.decoration.LinkType;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandMultiSubclass
extends SingleLineCommand2<ChenEerDiagram> {
    public CommandMultiSubclass() {
        super(CommandMultiSubclass.getRegexConcat());
    }

    protected static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCreateEntity.class.getName(), RegexLeaf.start(), new RegexLeaf("SUPERCLASS", "([\\w-]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("PARTICIPATION", "([-=])"), new RegexLeaf("(>)"), new RegexLeaf("PARTICIPATION2", "([-=])"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("SYMBOL", "([doU])"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{"), new RegexLeaf("SUBCLASSES", "(.+)"), new RegexLeaf("\\}"), RegexLeaf.spaceZeroOrMore(), CommandMultiSubclass.color().getRegex(), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(ChenEerDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        String superclass = diagram.cleanId(arg.get("SUPERCLASS", 0));
        String subclasses = arg.get("SUBCLASSES", 0);
        ArrayList<String> subclassIds = new ArrayList<String>();
        for (String subclass : subclasses.split(",")) {
            subclassIds.add(diagram.cleanId(subclass.trim()));
        }
        boolean isDouble = arg.get("PARTICIPATION", 0).equals("=");
        String symbol = arg.get("SYMBOL", 0);
        Colors colors = CommandMultiSubclass.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        Quark<Entity> centerQuark = diagram.quarkInContext(false, superclass + "/" + symbol + subclasses + "/center");
        Entity centerEntity = diagram.reallyCreateLeaf(centerQuark, Display.create(symbol), LeafType.CHEN_CIRCLE, null);
        centerEntity.setColors(colors);
        Quark<Entity> superclassQuark = diagram.quarkInContext(true, superclass);
        Entity superclassEntity = superclassQuark.getData();
        if (superclassEntity == null) {
            return CommandExecutionResult.error("No such entity: " + superclass);
        }
        LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE);
        if (isDouble) {
            linkType = linkType.goBold();
        }
        if (symbol.equals("U")) {
            linkType = linkType.withMiddleSuperset();
        }
        Link link = new Link(diagram, diagram.getCurrentStyleBuilder(), superclassEntity, centerEntity, linkType, LinkArg.build(Display.NULL, 2));
        link.setPortMembers(diagram.getPortId(superclassEntity.getName()), diagram.getPortId(centerEntity.getName()));
        link.setColors(colors);
        diagram.addLink(link);
        for (String subclass : subclassIds) {
            Quark<Entity> subclassQuark = diagram.quarkInContext(true, subclass);
            Entity subclassEntity = subclassQuark.getData();
            if (subclassEntity == null) {
                return CommandExecutionResult.error("No such entity: " + subclass);
            }
            LinkType subclassLinkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE);
            if (!symbol.equals("U")) {
                subclassLinkType = subclassLinkType.withMiddleSuperset();
            }
            Link subclassLink = new Link(diagram, diagram.getCurrentStyleBuilder(), centerEntity, subclassEntity, subclassLinkType, LinkArg.build(Display.NULL, 3));
            subclassLink.setColors(colors);
            diagram.addLink(subclassLink);
        }
        return CommandExecutionResult.ok();
    }
}

