/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionCollection;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.WithNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileDecorateWelding;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.WeldingPoint;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileIfAlone;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileIfHexagon;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.url.Url;

public class InstructionIf
extends WithNote
implements Instruction,
InstructionCollection {
    private final List<Branch> thens = new ArrayList<Branch>();
    private Branch elseBranch;
    private boolean endifCalled = false;
    private final ISkinParam skinParam;
    private final Url url;
    private final Instruction parent;
    private Branch current;
    private final LinkRendering topInlinkRendering;
    private LinkRendering outColor = LinkRendering.none();
    private final Stereotype stereotype;
    private final Swimlane swimlane;
    private final StyleBuilder currentStyleBuilder;

    @Override
    public boolean containsBreak() {
        for (Branch branch : this.thens) {
            if (!branch.containsBreak()) continue;
            return true;
        }
        if (this.elseBranch != null) {
            return this.elseBranch.containsBreak();
        }
        return false;
    }

    public InstructionIf(Swimlane swimlane, Instruction parent, Display labelTest, LinkRendering whenThen, LinkRendering inlinkRendering, HColor color, ISkinParam skinParam, Url url, Stereotype stereotype) {
        this.url = url;
        this.stereotype = stereotype;
        this.parent = parent;
        this.skinParam = skinParam;
        this.topInlinkRendering = Objects.requireNonNull(inlinkRendering);
        this.swimlane = swimlane;
        this.currentStyleBuilder = skinParam.getCurrentStyleBuilder();
        this.thens.add(new Branch(this.currentStyleBuilder, swimlane, whenThen, labelTest, color, LinkRendering.none(), stereotype));
        this.current = this.thens.get(0);
    }

    @Override
    public CommandExecutionResult add(Instruction ins) {
        return this.current.add(ins);
    }

    @Override
    public Gtile createGtile(ISkinParam skinParam, StringBounder stringBounder) {
        for (Branch branch : this.thens) {
            branch.updateGtile(skinParam, stringBounder);
        }
        ArrayList<Gtile> gtiles = new ArrayList<Gtile>();
        ArrayList<Branch> branches = new ArrayList<Branch>();
        for (Branch branch : this.thens) {
            gtiles.add(branch.getGtile());
            branches.add(branch);
        }
        if (this.elseBranch != null && !this.elseBranch.isEmpty()) {
            this.elseBranch.updateGtile(skinParam, stringBounder);
            gtiles.add(this.elseBranch.getGtile());
            branches.add(this.elseBranch);
        }
        if (branches.size() == 1) {
            return new GtileIfAlone(this.swimlane, (Gtile)gtiles.get(0), (Branch)branches.get(0));
        }
        return GtileIfHexagon.build(this.swimlane, gtiles, branches);
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        for (Branch branch : this.thens) {
            branch.updateFtile(factory);
        }
        if (this.elseBranch == null) {
            this.elseBranch = new Branch(this.currentStyleBuilder, this.swimlane, LinkRendering.none(), Display.NULL, null, LinkRendering.none(), this.stereotype);
        }
        this.elseBranch.updateFtile(factory);
        Ftile result = factory.createIf(this.swimlane, this.thens, this.elseBranch, this.outColor, this.topInlinkRendering, this.url, this.getPositionedNotes(), this.stereotype, this.currentStyleBuilder);
        ArrayList<WeldingPoint> weldingPoints = new ArrayList<WeldingPoint>();
        for (Branch branch : this.thens) {
            weldingPoints.addAll(branch.getWeldingPoints());
        }
        weldingPoints.addAll(this.elseBranch.getWeldingPoints());
        if (weldingPoints.size() > 0) {
            result = new FtileDecorateWelding(result, weldingPoints);
        }
        return result;
    }

    public Instruction getParent() {
        return this.parent;
    }

    public boolean swithToElse2(LinkRendering whenElse, LinkRendering nextLinkRenderer) {
        this.current.setSpecial(nextLinkRenderer);
        if (this.elseBranch != null) {
            return false;
        }
        this.current.setInlinkRendering(nextLinkRenderer);
        this.current = this.elseBranch = new Branch(this.skinParam.getCurrentStyleBuilder(), this.swimlane, whenElse, Display.NULL, null, LinkRendering.none(), this.stereotype);
        return true;
    }

    public boolean elseIf(LinkRendering inlabel, Display test, LinkRendering whenThen, LinkRendering nextLinkRenderer, HColor color) {
        if (this.elseBranch != null) {
            return false;
        }
        this.current.setSpecial(nextLinkRenderer);
        this.current = new Branch(this.skinParam.getCurrentStyleBuilder(), this.swimlane, whenThen, test, color, inlabel, this.stereotype);
        this.thens.add(this.current);
        return true;
    }

    public void endif(LinkRendering nextLinkRenderer) {
        this.endifCalled = true;
        if (this.elseBranch == null) {
            this.elseBranch = new Branch(this.skinParam.getCurrentStyleBuilder(), this.swimlane, LinkRendering.none(), Display.NULL, null, LinkRendering.none(), this.stereotype);
        }
        this.elseBranch.setSpecial(nextLinkRenderer);
        this.current.setInlinkRendering(nextLinkRenderer);
    }

    @Override
    public final boolean kill() {
        Iterator<Branch> iterator;
        if (this.endifCalled && (iterator = this.thens.iterator()).hasNext()) {
            Branch branch = iterator.next();
            if (branch.getLast() != null && !branch.getLast().kill()) {
                return false;
            }
            return this.elseBranch == null || this.elseBranch.getLast() == null || this.elseBranch.getLast().kill();
        }
        return this.current.kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.topInlinkRendering;
    }

    @Override
    public boolean addNote(Display note, NotePosition position, NoteType type, Colors colors, Swimlane swimlaneNote, Stereotype stereotype) {
        if (this.endifCalled || this.current.isEmpty()) {
            return super.addNote(note, position, type, colors, swimlaneNote, stereotype);
        }
        return this.current.addNote(note, position, type, colors, swimlaneNote, stereotype);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> result = new HashSet<Swimlane>();
        if (this.swimlane != null) {
            result.add(this.swimlane);
        }
        for (Branch branch : this.thens) {
            result.addAll(branch.getSwimlanes());
        }
        if (this.elseBranch != null) {
            result.addAll(this.elseBranch.getSwimlanes());
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    @Override
    public Instruction getLast() {
        if (this.elseBranch == null) {
            return this.thens.get(this.thens.size() - 1).getLast();
        }
        return this.elseBranch.getLast();
    }

    public void outColor(LinkRendering outColor) {
        this.outColor = outColor;
    }
}

