# ***************************************************************
# ***************************************************************
#
# Description:	This script is run automatically by all 
#				executables that support the --shell or -s command.
#				It emulates support for a console
#
# Version:		1.0
#
# Authors:		 Altera Corporation
#
#               Copyright (c)  Altera Corporation 1999 - 2002
#               All rights reserved.
#
# ***************************************************************
# ***************************************************************

set tcl_command ""

# q_unknown -- (modified version of init.tcl's unknown)
# This procedure is called when a Tcl command is invoked that doesn't
# exist in the interpreter.  It takes the following steps to make the
# command available:
#
#	1. If the command was invoked interactively at top-level:
#	    (a) see if the command exists as an executable UNIX program.
#		If so, "exec" the command.
#	    (b) see if the command requests csh-like history substitution
#		in one of the common forms !!, !<number>, or ^old^new.  If
#		so, emulate csh's history substitution.
#	    (c) see if the command is a unique abbreviation for another
#		command.  If so, invoke the command.
#
# Arguments:
# args -	A list whose elements are the words of the original
#		command, including the command name.

proc q_unknown args {
    global auto_noexec 
    global errorCode errorInfo

    # If the command word has the form "namespace inscope ns cmd"
    # then concatenate its arguments onto the end and evaluate it.

    set cmd [lindex $args 0]
    if {[regexp "^namespace\[ \t\n\]+inscope" $cmd] && [llength $cmd] == 4} {
        set arglist [lrange $args 1 end]
		set ret [catch {uplevel $cmd $arglist} result]
        if {$ret == 0} {
            return $result
        } else {
			return -code $ret -errorcode $errorCode $result
        }
    }

    # Save the values of errorCode and errorInfo variables, since they
    # may get modified if caught errors occur below.  The variables will
    # be restored just before re-executing the missing command.

    set savedErrorCode $errorCode
    set savedErrorInfo $errorInfo

	# The caller may have put all arguments between "", so we need to assume
	# that we still have a second list at this point. Split it and and then
	# try to get the first argument
    set name [lindex [split [lindex $args 0] " "] 0]
	set arglist [lrange [split [lindex $args 0] " "] 1 end]
	for { set i 0 } { $i < [llength $arglist] } { incr i } {
			set argv($i) [lindex $arglist $i]
	}
	
	if {![info exists auto_noexec]} {
	    set new [auto_execok $name]
	    if {[string compare {} $new]} {
			set errorCode $savedErrorCode
			set errorInfo $savedErrorInfo
			set redir ""
			if {[string equal [info commands console] ""]} {
				set redir ">&@stdout <@stdin"
			}
			# Must use eval here to expand the arglist, allowing us to
			# pass an arbitrary number of arguments.
			return [eval exec $new $arglist]
	    }
	}
	set errorCode $savedErrorCode
	set errorInfo $savedErrorInfo
	if {[string equal $name "!!"]} {
	    set newcmd [history event]
	} elseif {[regexp {^!(.+)$} $name dummy event]} {
	    set newcmd [history event $event]
	} elseif {[regexp {^\^([^^]*)\^([^^]*)\^?$} $name dummy old new]} {
	    set newcmd [history event -1]
	    catch {regsub -all -- $old $newcmd $new newcmd}
	}

	if {[info exists newcmd]} {
	    tclLog $newcmd
	    history change $newcmd 0
	    return [uplevel $newcmd]
	} else {
		return -code error "invalid command name \"$name\""
	}
}

# q_display_banner
# This procedure is called to display a banner with basic help about 
# the console

proc q_display_banner {} {

	puts "Info: **********************************************************"
	puts "Info: This console supports all TCL commands in addition to"
	puts "Info: max2synw-specific commands"
	puts "Info: All unrecognized commands will be assumed to be external "
	puts "Info: and will be run using TCL's exec command"
	puts "Info: To exit, type \"exit\""
	puts "Info: For a list of all max2synw-specific commands, type \"help\""
	puts "Info: **********************************************************"
	puts ""
}


# Display Help
q_display_banner
	

# Go into an infinite loop evaluating commands
# The user has to call TCL's "exit" to exit
while { 1 } {

	# Prevent infinite loops when a script is redirected to stdin.
	if {[eof stdin]} { exit 0; }
	
	puts -nonewline "tcl> "
	flush stdout
	set tcl_command [gets stdin]

	# Call TCL interpreter to evaluate command
	catch {eval $tcl_command} result

	if { [string match "*invalid*" $result] } {
		catch { q_unknown $tcl_command } result
		if {$result ==1 } {
			history add $tcl_command
		}
	} else {
		# Update History
		history add $tcl_command
	}


	# If the command is missing a close brace
	# go into a loop, appending the subsequent commands
	# and calling eval until the result is no longer 
	# a missing close-brace
	while { [string match $result "missing close-brace"] } {
		# Prevent infinite loops when a script is redirected to stdin.
		# Make this one return non-zero, since the command will not be completed.
		if {[eof stdin]} { exit 1; }

		puts -nonewline "> "
		flush stdout
		append tcl_command [gets stdin] "\n"
		catch {eval $tcl_command} result
	} 

	# Only display results when its is not empty
	if { [ string compare $result ""] } {
		puts $result
	}
}
