# START_MODULE_HEADER/////////////////////////////////////////////////////
#
# Filename:    ccl_msg.tcl
#
# Description: Tcl/Tk interface for MAX+plus II Advanced Synthesis 
#
# Authors:     Scott Redman
#
#              Copyright (c) Altera Corporation 1997 - 2003
#              All rights reserved.
#
# END_MODULE_HEADER///////////////////////////////////////////////////////
#
# log removed...

if { $tcl_platform(os) == "Linux" } {
rename puts temp_puts
proc puts {args} {
     if {[llength $args] == 1} {
       ::max2syn::MSG_DISPLAY::tcl_puts [lindex $args 0]
    } else {
        eval temp_puts $args
    }
}
}


# Try to load package statically first
if [ catch { load "" Ccl_msg } load_result ] {
	# If static load fails, load dynamic lib
	if { $tcl_platform(platform) == "unix" } {
		if { $tcl_platform(os) == "HP-UX" } {
			load "[file dirname [info script]]/libccl_msg.sl"
		} else {
			load "[file dirname [info script]]/libccl_msg.so"
		}
	} else {
		load "[file dirname [info script]]/ccl_msg.dll"
	}
}

proc ::max2syn::create_post_message_recurse { report msg } {

	set msg_ptr [eval ::max2syn::MSG_POST::from_tcl_string $msg]

	# sub messages...
	foreach i [lindex $msg 4] {
		
		set submsg_ptr [::max2syn::create_post_message_recurse $report $i]
		
		::max2syn::MSG_POST::tcl_add_submsg $msg_ptr $submsg_ptr
		
	}

	if { $report != 0 && $report != -1} {
		::max2syn::MSG_REPORT::tcl_log_post_message_recurse $report $msg_ptr $msg
	}

	# locations...
	foreach i [lindex $msg 5] {
		set temp 0
		set location 0
		# need to convert the schema first,
		# before passing it to MSG_LOCATION::from_tcl_string
		if { [llength [lindex $i 3]] != 0 } {
			set temp [eval ::max2syn::MSG_LOCATION_SCHEMA::from_tcl_string [lindex $i 3]]
			set location [::max2syn::MSG_LOCATION::from_tcl_string [lindex $i 0] [lindex $i 1] [lindex $i 2] $temp]
			::max2syn::MSG_POST::tcl_add_location $msg_ptr $location
		}
	}
	return $msg_ptr
}

proc ::max2syn::default_print_post_message { indent msg } {

	set str ""
	for { set i 0 } { $i < $indent } { incr i 1 } {
		set str "    $str"
	}
	set str "$str[lindex $msg 0]: [lindex $msg 3]"

#The native tcl puts function was flushing the buffer after every line
#See SPR 82729.  The following puts() does not flush the stdout buffer
#(but it will be flushed when the process ends)
	::max2syn::MSG_DISPLAY::tcl_puts $str
	
	foreach submsg [lindex $msg 4] {
		::max2syn::default_print_post_message [expr $indent + 1] $submsg
	}	
}

proc ::max2syn::default_post_message { report msg } {

	if [catch {
		set display [::max2syn::MSG_REPORT::tcl_get_display $report]
		set msg_ptr [::max2syn::create_post_message_recurse $report $msg]
		
		if { $report != 0  && $report != -1 } {
			::max2syn::MSG_REPORT::tcl_log_post_message $report $msg_ptr $msg
		}
		if { $display != 0 } {
			::max2syn::MSG_DISPLAY::tcl_post_message $display $msg_ptr
		} else {
			::max2syn::default_print_post_message 0 $msg
		}
		::max2syn::MSG_REPORT::tcl_free_msg_ptr $report $msg_ptr
	} error_code ] {
		puts "Error posting message $msg"
	}
}

proc ::max2syn::default_prompt_message { report msg } {
	set result 0
	if [catch {
		set display [::max2syn::MSG_REPORT::tcl_get_display $report]
		set msg_ptr [eval ::max2syn::MSG_PROMPT::from_tcl_string $msg]
	
		if { $report != 0  && $report != -1 } {
			::max2syn::MSG_REPORT::tcl_log_prompt_message $report $msg_ptr $msg
		}
		if { $display != 0 } {
			set result [::max2syn::MSG_DISPLAY::tcl_prompt_message $display $msg_ptr]
		} else {
			if { [lindex $msg 0] == "OK" } {
				# OK messages can just be printed out...
				puts [lindex $msg 3]
			} else {
				# do nothing
			}
		}
	} error_code ] {
		puts "Error prompting message $msg"
	}
	return $result
}

proc ::max2syn::default_internal_error { report text } {
	if [catch {
		set display [::max2syn::MSG_REPORT::tcl_get_display $report]
		
		if { $report != 0  && $report != -1 } {
			::max2syn::MSG_REPORT::tcl_log_internal_error $report $text
		}

		if { $display != 0 } {
			::max2syn::MSG_DISPLAY::tcl_internal_error_display $display $text
		} else {

# Internal errors must also use tcl_puts if debug messages use it.
# Otherwise, an internal error will be printed in the middle of a
# debug message when redirecting the output of max2syn to a file.
# See SPR 89987
			::max2syn::MSG_DISPLAY::tcl_puts $text
		}
	} error_code ] {
		puts "Error posting internal error message $text"
	}
}

proc InternalError { report text } {
	::max2syn::default_internal_error $report $text
}

proc postMessage { report msg } {
	global _q_cli_msg_sock
	::max2syn::default_post_message $report $msg
	if { [info exists _q_cli_msg_sock] } {
		puts $_q_cli_msg_sock $msg
	}
}

proc promptMessage { report msg } {
	::max2syn::default_prompt_message $report $msg
}

proc disable_msg_box {} {
	::max2syn::MSG_DISPLAY::tcl_disable_msg_box
}

proc enable_msg_box {} {
	::max2syn::MSG_DISPLAY::tcl_enable_msg_box
}

