----------------------------------------------------------------------------------------------
-- ALTMEMMULT.INC
--
-- This megafunction implements a RAM-based multiplier
--
-- (C) Alter Corporation, 2002
----------------------------------------------------------------------------------------------
FUNCTION altmemmult (
						clock,
						coeff_in[WIDTH_C-1..0],		-- input coefficient
						data_in[WIDTH_D-1..0],		-- input variable data
						sclr,						-- synchronously clear all the registers
						select[WIDTH_S-1..0],		-- selects one of the fixed coefficients
						sload_data,					-- synchronously loads data
						sload_coeff					-- synchronously loads coeff through coeff_in
					)			
					WITH
					(
						WIDTH_D,				-- width of input bus. Resolution of data samples
						WIDTH_C,				-- width of fixed coefficients
						WIDTH_S = 1,				-- width in bits of coefficient selection bus
						WIDTH_R,				-- width of result output bus
						COEFFICIENT0,				-- number of coefficients stored in lookup table
						TOTAL_LATENCY,
						MAX_CLOCK_CYCLES_PER_RESULT,
						RAM_BLOCK_TYPE,
						DATA_REPRESENTATION		-- indicates whether data_in[] is signed or unsigned
					)
					RETURNS
					(
						result[WIDTH_R-1..0],
						result_valid,
						load_done
					);
	
