#! /bin/csh -f

# don't let CTRL-C stop this script from continuing
onintr -

if (! $?MAX2SYN_ROOT) then
	setenv SCRIPT_PATH `dirname $0`

	if ("${SCRIPT_PATH}" == "") then
        # in case the dirname doesn't work, use "which" (slower)
		setenv SCRIPT_PATH `which $0 |& tail -1`
	endif

	if ("${SCRIPT_PATH}" == "." || "${SCRIPT_PATH}" == "") then
		setenv MAX2SYN_ROOT `dirname $cwd`
	else 
		setenv MAX2SYN_ROOT `dirname ${SCRIPT_PATH}`
	endif

	if ("${MAX2SYN_ROOT}" == "..") then
		setenv MAX2SYN_ROOT `dirname $cwd`
	endif
endif

if ( "${MAX2SYN_ROOT}" !~ /* ) then
	setenv MAX2SYN_ROOT `(cd ${MAX2SYN_ROOT} ; pwd)`
endif

setenv CMD_NAME `basename $0`

source ${MAX2SYN_ROOT}/adm/qenv.csh

if ($QENV_STATUS != 0) exit $QENV_STATUS

if ($CMD_NAME !~ m*) then
	setenv NO_CHECK_PATCHES 1
endif

# Check to make sure the right system patches are installed
if ( ! $?NO_CHECK_PATCHES ) then
	check_patches
	set result=$status
	if ( $MAX2SYN_PLATFORM == solaris ) then
		if ( $result != 0 ) then
			setenv MWNO_RIT 1
			setenv MWDONT_XINITTHREAD 1
			setenv LD_LIBRARY_PATH ${MAX2SYN_ROOT}/adm/syslibs/${UNAME_REVISION}:$LD_LIBRARY_PATH
			echo "Because some operating system patches are not installed, the stablility of the "
			echo "MAX+plus II Advanced Synthesis software may be affected."
		else
			unsetenv MWNO_RIT
			unsetenv MWDONT_XINITTHREAD
		endif
	endif
endif

exec $CMD_NAME $*
