if ( ! $?MAX2SYN_QENV ) then
setenv MAX2SYN_QENV 1
setenv QENV_STATUS 0


if ( ! $?MAX2SYN_ROOT ) then
	setenv MAX2SYN_ROOT ---MAX2SYN_ROOT_DEFAULT---
endif

if ( ! $?MAXPLUS2_ROOT ) then
	setenv MAXPLUS2_ROOT ---MAXPLUS2_ROOT_DEFAULT---
endif


if (! $?TMP) then
	setenv TMP /tmp
else if ( ! -d $TMP ) then
	setenv TMP /tmp
endif

# max2syn doesn't support other languages
# so if LANG is set make sure its C
if ($?LANG) then
	if ("$LANG" != "C") setenv LANG C
endif

setenv MAX2SYN_PATH /usr/bin
if ( $?MAX2SYN_INIT_PATH ) then
	setenv MAX2SYN_PATH ${MAX2SYN_PATH}:${MAX2SYN_INIT_PATH}
endif

if ( $?MAX2SYN_INIT_LIBPATH ) then
	setenv MAX2SYN_LIBPATH ${MAX2SYN_INIT_LIBPATH}
else
	setenv MAX2SYN_LIBPATH ""
endif

if ( $?MAX2SYN_MWHOME ) then
	setenv MWHOME $MAX2SYN_MWHOME
else
	setenv MWHOME ${MAXPLUS2_ROOT}/mw
endif

# Need to unset MWCURRENT_LIBPATH so environment gets initialized from scratch
unsetenv MWCURRENT_LIBPATH
# set PATH to basic so we can use it to pick up the Mainwin required paths
# saving original path first
setenv MAX2SYN_ORIG_PATH $PATH
setenv PATH /usr/bin:/bin
if ( -f ${MWHOME}/setupmainwin.csh && ! $?MWRELEASE) then
	source ${MWHOME}/setupmainwin.csh
else
	source ${MWHOME}/setmwruntime.csh
endif
setenv MAX2SYN_LIBPATH ${MWCURRENT_LIBPATH}:${MAX2SYN_LIBPATH}
setenv MAX2SYN_PATH ${PATH}:${MAX2SYN_PATH}

# this var causes crashes during drag & drop
unsetenv MWUNIX_SHARED_MEMORY
# this var prevents SIGALRM's from interrupting code
setenv MWNO_SIGALARM_CATCHING 1
# this var prevents fonts from being bold in dialogs
setenv MWUSE_FIXED_SCREENDPI 1
# this var prevents fonts from being bigger in dialogs than in the main frame
setenv MWNT_DIALOG_SIZING 1

if ( $?MAX2SYN_MWWM ) then
	setenv MWWM ${MAX2SYN_MWWM}
else
	unsetenv MWWM
endif

# this makes the max2syn shared memory segment unique
if (! $?MAX2SYN_NO_SHM_KEY) then
	set id=`id`
	set id=`echo $id | sed -e 's/uid=//g' -e 's/(.*//g'`
	setenv MWSHM_KEY `expr 10000 + $$ + $id`
endif

setenv UNAME_SYSTEM `uname -s`
setenv UNAME_REVISION `uname -r`
setenv UNAME_VERSION `uname -v`

if (${MWOS} == sunos5) then
	setenv MAX2SYN_PLATFORM solaris
	setenv PATCH_CMD "showrev -a"
	setenv AWK_CMD "nawk"
	setenv MIN_OS_REVISION 5.6
	setenv LD_BREADTH 1
	if ($UNAME_REVISION == 5.8) then
		setenv LD_BIND_NOW 1
	else
		unsetenv LD_BIND_NOW
	endif
	setenv SYSTEM_MEMORY "`/usr/sbin/prtconf | /bin/grep Memory | /usr/bin/sed -e 's/Memory size: \([0-9]*\).*/\1/'`"
else if (${MWOS} == ux10) then
	setenv MAX2SYN_PLATFORM hp
	setenv PATCH_CMD "/usr/sbin/swlist -v"
	setenv AWK_CMD "awk"
	setenv MIN_OS_REVISION B.10.20
else if (${MWOS} == ux11) then
	setenv MAX2SYN_PLATFORM hp11
	setenv PATCH_CMD "/usr/sbin/swlist -v"
	setenv AWK_CMD "awk"
	setenv MIN_OS_REVISION B.11.00
else if (${MWOS} == linux) then
	setenv MAX2SYN_PLATFORM linux
	setenv PATCH_CMD ""
	setenv AWK_CMD "awk"
	setenv MIN_OS_REVISION 2.2.14
	if ( $?LC_CTYPE ) then
		if ( $LC_CTYPE == POSIX ) then
			setenv LC_CTYPE en_US
		endif
		if ( $LC_CTYPE == C ) then
			setenv LC_CTYPE en_US
		endif
	else
		unsetenv LC_ALL
		setenv LC_CTYPE en_US
	endif
else
	echo "Unsupported platform!"
	setenv QENV_STATUS -1
	exit
endif

if ( `expr $UNAME_REVISION \< $MIN_OS_REVISION` ) then
	echo "You must run the MAX+plus II Advanced Synthesis software under an"
	echo "operating system of version $MAX2SYN_PLATFORM $MIN_OS_REVISION or later."
	setenv QENV_STATUS -2
	exit
endif

if ( ! -d ${MAX2SYN_ROOT}/${MAX2SYN_PLATFORM} ) then
	echo "You must install the MAX+plus II Advanced Synthesis software"
	echo "for this platform (${MAX2SYN_PLATFORM}) before running."
	setenv QENV_STATUS -3
	exit
endif

setenv TCL_LIBRARY ${MAX2SYN_ROOT}/${MAX2SYN_PLATFORM}/tcl8.3

setenv MAX2SYN_LIBPATH ${MAX2SYN_ROOT}/${MAX2SYN_PLATFORM}:${MAX2SYN_LIBPATH}
setenv MAX2SYN_PATH ${MAX2SYN_ROOT}/adm:${MAX2SYN_ROOT}/${MAX2SYN_PLATFORM}:${MAX2SYN_PATH}

# Save original library path before setting for max2syn 
if (${MWOS} == sunos5 || ${MWOS} == linux) then
	setenv MAX2SYN_ORIG_LIBPATH $LD_LIBRARY_PATH
	setenv LD_LIBRARY_PATH $MAX2SYN_LIBPATH
else if (${MWOS} == ux10 || ${MWOS} == ux11) then
	setenv MAX2SYN_ORIG_LIBPATH $SHLIB_PATH
	setenv SHLIB_PATH $MAX2SYN_LIBPATH
endif
unsetenv MAX2SYN_LIBPATH

# original path is already saved in MAX2SYN_ORIG_PATH before mainwin init
setenv PATH $MAX2SYN_PATH
unsetenv MAX2SYN_PATH

if ( ! -d ~/windows ) mkdir ~/windows
if ( ! -d ~/windows/system ) mkdir ~/windows/system
if ($?MAX2SYN_MWREGISTRY) then
    setenv MWREGISTRY $MAX2SYN_MWREGISTRY
else
	setenv MWREGISTRY ~/windows/system/max2syn_registry_${MWOS}.bin
endif

if ( ! { regcheck } ) then
	echo "Creating new Mainwin registry at $MWREGISTRY"
	mwregedit -new -silent >& /dev/null
endif

setenv PROC_ID `getpid`

# endif for "if ( ! $?MAX2SYN_QENV ) then"
endif
