

function Sort-Courses
{
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$False)]
        [string]$MainPath = "X:\media\Courses\Unpack"
    ) 

    $FolderList = Get-ChildItem -Path $MainPath
    foreach ($Item in $FolderList)
    {
        $ParentFolderPath = $Item.FullName
        $ParentFolderContents = Get-ChildItem -path $ParentFolderPath | Sort-Object

        foreach ($Item in $ParentFolderContents)
        {
            $Content = Get-ChildItem -Path $Item.FullName


            ForEach ($File in $Content)
            {
                $filename = ''
                $basename = ''
                $oldpath = ''
                $basename += $File.BaseName
                $filename += $basename -replace '--- \[ FreeCourseWeb.com \] ---', ''

                [string]$NewPath = $ParentFolderPath + "\" + (Select-String -InputObject $Item.BaseName -Pattern "[0-9]+(?=)").Matches.Value + " - " + $Filename + $File.Extension

                $oldpath += $file.FullName
                write-host $file.FullName
                Write-Host -Foregroundcolor Green $NewPath

                move-item -literalpath $oldpath -destination $newpath


            }
            $FoldersToDelete = ($Content | Where-Object -FilterScript {($_.Directory -eq $True) -and ($_.Length -eq 0)}).FullName
            
            try 
            {
                Remove-Item -Path $FoldersToDelete
            }

            catch
            {
                Write-Host $_.Exception.InnerException
            }

        }
    }

}
