function Show-ExceptionType
{
        [CmdletBinding()]
        param (
            [Parameter(Mandatory)]
            [System.Exception]
            $Exception
        )

        $Indent = 0
        $E = $Exception

        While($E)
        {
            Write-Host ("{0,$Indent}{1}" -f '', $E.GetType().FullName)
            $Indent += 2
            $E = $E.InnerException
        }
        
}