<#
.SYNOPSIS
    Provides a list of available windows updates that you can install selectively.

.DESCRIPTION
    1. Scans the computer for updates (using CIM instance)
    2. Outputs the list of updates in out-gridview, where the user can select which updates they'd like to apply.
    3. Applies the selected updaets
    
.PARAMETER ComputerName
    The name of the computer you'd like this script run on. (Default is the local machine)
    
.EXAMPLE
    Select-WindowsUpdates -ComputerName "Cameron"

.EXAMPLE
    Select-WindowsUpdates

.NOTES
    Author: Cameron Ratchford
    Date:   June 4 2020   
#>

function Select-WindowsUpdates
{
    [CmdletBinding()]
    param (
        [Parameter(Mandatory=$false)]
        [ValidateNotNullOrEmpty()]
        [string]$ComputerName=$ENV:COMPUTERNAME
    )

    $cimsess = New-CimSession -ComputerName $ComputerName

    $scanres = (Invoke-CimMethod -Namespace root/Microsoft/Windows/WindowsUpdate -ClassName MSFT_WUOperations -MethodName ScanForUpdates -CimSession $cimsess).updates

    $updates = $scanres | Out-GridView -Title "Please Select the Updates You'd Like to Install" -PassThru

    try
    {
        Install-WUUpdates -Updates $updates -CimSession $cimsess
    }

    catch [System.Management.Automation.ValidationMetadataException]
    {
        Write-Warning "There are no updates to apply on $ComputerName"
    }

    catch
    {
        show-exceptiontype $_.Exception
    }

}
