
function Expand-Courses 
{
    [CmdletBinding()]
    param (
        [Parameter(Mandatory=$true)]
        [ValidateNotNullOrEmpty()]
        [string]$Folder
    )
    $ArchiveExtensions = ".7z", ".rar", ".zip", ".tgz", ".tar", ".gz"

    $ParentDirectory = Get-ChildItem -Path $Folder -Directory

    foreach ($Dir in $ParentDirectory) {
        $FolderContent = Get-ChildItem -path $Dir.FullName | Where-Object -FilterScript {$ArchiveExtensions -contains $_.Extension}
        Write-Host $FolderContent
        foreach ($Item in $FolderContent)
        {
            if ($Item.FullName)
            {
                $OldPath = "'" + $Item.FullName + "'"
                $NewPath =  "'" + (Join-Path -Path $Folder -ChildPath $Item.BaseName) + "'"
                # "7z is 7zip", "x" is extract while maintaining file paths, "-r" is recurse through sub-directories, "-spe" is eliminate duplication of root folder for extract command, "-y" is confirm, "-o" is output directory
                # Invoke-Command -scriptblock {write-host " 7z x -r -spe -y ${OldPath} -o${NewPath}"} -ArgumentList $OldPath, $NewPath -ErrorAction Stop -Verbose
                # write-host "Invoke-Command -scriptblock { param ($OldPath, $NewPath) powershell `"7z x -r -spe -y $OldPath -o$NewPath`"} -ArgumentList $OldPath, ${NewPath}"
    
                Invoke-Command -scriptblock { param ($OldPath, $NewPath)powershell -NoProfile "7z x -r -spe -y $OldPath -o$NewPath"} -ArgumentList $OldPath, ${NewPath} -ErrorAction Stop -Verbose
    
                # 7z x -r -spe -y "Z:\Courses\Compressed\Linux Administration with Advance Troubleshooting Skills.zip" -o"Z:\Courses\Compressed\Linux Administration with Advance Troubleshooting Skills\"
            }
        }
    }    
}

