function Copy-RoboCopy {
    [CmdletBinding()]
    param(
        [Parameter(Mandatory=$true)]
        [string]$SourceFolder,
        [Parameter(Mandatory=$true)]
        [string]$DestinationFolder,
        [Parameter(Mandatory=$false)]
        [string[]]$Except
        )


        $ExceptionOption = @()
        if (!($Except))
        {
            $ExceptionOption = " "
        }

        elseif (($Except.GetType().BaseType -eq  [System.Array]) -and ($Except.Length -gt 1)) 
        {
            Write-Host "Here"
            foreach ($ex in $Except)
            {
                $ExceptionOption += ("/xd {0}" -f $ex)
            }
        }

        elseif ($Except.GetType() -eq  [System.String])
        {
            $ExceptionOption = ("/xd {0}" -f $Except)
        }


        if ($SourceFolder.LastIndexOf("\"))
        {
            $SourceFolder = $SourceFolder.TrimEnd("\")
        }
        
        if ($DestinationFolder.LastIndexOf("\"))
        {
            $DestinationFolder = $DestinationFolder.TrimEnd("\")
        }

        $Params = @{
            ScriptBlock = { 
                Param ($SourceFolder, $DestinationFolder)
                C:\Windows\System32\Robocopy.exe $SourceFolder $DestinationFolder /e /z /r:0 /w:0 /copy:DAT /xd `$RECYCLE.BIN /xd "System Volume Information" $ExceptionOption
            }
            ArgumentList = $SourceFolder, $DestinationFolder
            
        }
        Invoke-Command @Params
}


