function Clear-CourseFolders
{
    [CmdletBinding()]
    param (
        [Parameter(Mandatory=$true)]
        [ValidateNotNullOrEmpty()]
        [string]$Folder
    )

    # Get list of course directories in parent folder
    $ParentFolder = Get-ChildItem -Path $Folder


    # Iterate through them
    foreach ($Dir in $ParentFolder) {

        # Remove txt, nfo files, empty folders, etc.
        $ExtensionsToDelete = ".nfo", ".txt", ".v", ".htm", ".html"

        $FilesToDelete =  Get-ChildItem -Path $Dir.FullName | Where-Object -FilterScript {$ExtensionsToDelete -contains $_.Extension}

        $EmptyFolders = Get-ChildItem -Path $Dir.FullName -Directory | Where-Object -FilterScript {-not $_.Length} 

        foreach ($F in $FilesToDelete) {
            Write-Host "`n Deleting" $F.FullName
            #Remove-Item -Path $item.FullName -Force
        }

        foreach ($F in $EmptyFolders) {
            Write-Host "`n Deleting" $F.fullname
            #Remove-Item -Path $item.FullName -Force
        }

    }
    
}
